/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.repository.InternalRepository;
import jakarta.annotation.Nonnull;
import java.util.Arrays;

public enum RepositoryOrder {
    PROJECT_NAME{

        @Override
        @Nonnull
        public Iterable<HqlQueryBuilder.HqlQueryOrder> getOrder() {
            return Arrays.asList(HqlQueryBuilder.HqlQueryOrder.asc(RepositoryOrder.PROJECT_NAME_COLUMN).ignoreCase(), HqlQueryBuilder.HqlQueryOrder.asc(RepositoryOrder.REPO_NAME_COLUMN).ignoreCase(), HqlQueryBuilder.HqlQueryOrder.asc(RepositoryOrder.REPO_ID_COLUMN));
        }
    }
    ,
    REPO_NAME{

        @Override
        @Nonnull
        public Iterable<HqlQueryBuilder.HqlQueryOrder> getOrder() {
            return Arrays.asList(HqlQueryBuilder.HqlQueryOrder.asc(RepositoryOrder.REPO_NAME_COLUMN).ignoreCase(), HqlQueryBuilder.HqlQueryOrder.asc(RepositoryOrder.REPO_ID_COLUMN));
        }
    };

    public static final RepositoryOrder DEFAULT;
    private static final String REPO_NAME_COLUMN = "name";
    private static final String REPO_ID_COLUMN = "id";
    private static final String PROJECT_NAME_COLUMN = "project.name";

    public void apply(@Nonnull HqlQueryBuilder<InternalRepository> builder) {
        for (HqlQueryBuilder.HqlQueryOrder order : this.getOrder()) {
            builder.orderBy(order);
        }
    }

    @Nonnull
    public abstract Iterable<HqlQueryBuilder.HqlQueryOrder> getOrder();

    static {
        DEFAULT = REPO_NAME;
    }
}

