/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryArchiveFilter;
import com.atlassian.bitbucket.repository.RepositoryVisibility;
import com.atlassian.stash.internal.repository.RepositoryOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RepositorySearchCriteria {
    private final Boolean archived;
    private final String name;
    private final RepositoryOrder order;
    private final String projectName;
    private final String projectKey;
    private final Repository.State state;
    private final RepositoryVisibility visibility;

    private RepositorySearchCriteria(Builder builder) {
        this.archived = builder.archived;
        this.name = builder.name;
        this.order = builder.order;
        this.projectName = builder.projectName;
        this.projectKey = builder.projectKey;
        this.state = builder.state;
        this.visibility = builder.visibility;
    }

    @Nonnull
    public RepositoryOrder getOrder() {
        return this.order;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nullable
    public String getProjectName() {
        return this.projectName;
    }

    @Nullable
    public Repository.State getState() {
        return this.state;
    }

    @Nullable
    public RepositoryVisibility getVisibility() {
        return this.visibility;
    }

    public boolean hasArchived() {
        return this.archived != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasProjectKey() {
        return this.projectKey != null;
    }

    public boolean hasProjectName() {
        return this.projectName != null;
    }

    public boolean hasState() {
        return this.state != null;
    }

    public boolean hasVisibility() {
        return this.visibility != null;
    }

    @Nullable
    public Boolean getArchived() {
        return this.archived;
    }

    public static class Builder {
        private Boolean archived = false;
        private String name;
        private String projectKey;
        private String projectName;
        private RepositoryOrder order = RepositoryOrder.DEFAULT;
        private Repository.State state;
        private RepositoryVisibility visibility;

        @Nonnull
        public RepositorySearchCriteria build() {
            return new RepositorySearchCriteria(this);
        }

        @Nonnull
        public Builder archived(@Nullable RepositoryArchiveFilter value) {
            this.archived = value == null ? null : value.flag();
            return this.self();
        }

        @Nonnull
        public Builder name(@Nullable String value) {
            this.name = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Nonnull
        public Builder order(@Nonnull RepositoryOrder value) {
            this.order = Objects.requireNonNull(value, "order");
            return this.self();
        }

        @Nonnull
        public Builder projectKey(@Nullable String value) {
            this.projectKey = value;
            return this.self();
        }

        @Nonnull
        public Builder projectName(@Nullable String value) {
            this.projectName = value;
            return this.self();
        }

        @Nonnull
        public Builder state(@Nullable Repository.State value) {
            this.state = value;
            return this;
        }

        @Nonnull
        public Builder visibility(@Nullable RepositoryVisibility value) {
            this.visibility = value;
            return this.self();
        }

        private Builder self() {
            return this;
        }
    }
}

