/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.jenkins;

import com.atlassian.bitbucket.build.server.operations.BuildOperations;
import com.atlassian.bitbucket.build.server.operations.BuildStatusAction;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class JenkinsBuildOperations
implements BuildOperations {
    private final List<BuildStatusAction> actions;
    private final boolean isAuthorizationRequired;

    private JenkinsBuildOperations(Builder builder) {
        this.actions = builder.actions.build();
        this.isAuthorizationRequired = builder.isAuthorizationRequired;
    }

    @Nonnull
    public List<BuildStatusAction> getActions() {
        return this.actions;
    }

    public boolean isAuthorizationRequired() {
        return this.isAuthorizationRequired;
    }

    public static final class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<BuildStatusAction> actions = ImmutableList.builder();
        private boolean isAuthorizationRequired;

        @Nonnull
        public Builder actions(BuildStatusAction ... values) {
            this.actions.addAll(Arrays.asList(Objects.requireNonNull(values, "actions")));
            return this;
        }

        @Nonnull
        public BuildOperations build() {
            return new JenkinsBuildOperations(this);
        }

        @Nonnull
        public Builder isAuthorizationRequired(boolean value) {
            this.isAuthorizationRequired = value;
            return this;
        }
    }
}

