/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.jenkins;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.generic.GenericApplicationType;
import com.atlassian.bitbucket.build.server.PluginBuildServer;
import com.atlassian.bitbucket.build.server.PluginBuildServerProvider;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.build.jenkins.HttpHeaderFetcher;
import com.atlassian.bitbucket.internal.build.jenkins.JenkinsBuildServerSignatureValidator;
import com.atlassian.bitbucket.internal.build.jenkins.JenkinsPluginBuildServer;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsBuildServerProvider
implements PluginBuildServerProvider {
    private static final String ALGORITHM_HEADER = "BBS-Signature-Algorithm";
    private static final String BASE_URL_HEADER = "base-url";
    private static final String SIGNATURE_HEADER = "BBS-Signature";
    private static final Logger log = LoggerFactory.getLogger(JenkinsBuildServerProvider.class);
    private final ApplicationLinkService applicationLinkService;
    private final I18nService i18nService;
    private final JenkinsBuildServerSignatureValidator jenkinsBuildServerSignatureValidator;
    private final Cache<ApplicationId, PublicKey> publicKeyCache;

    public JenkinsBuildServerProvider(ApplicationLinkService applicationLinkService, CacheManager cacheManager, I18nService i18nService) {
        this(applicationLinkService, cacheManager, i18nService, new JenkinsBuildServerSignatureValidator());
    }

    @VisibleForTesting
    JenkinsBuildServerProvider(ApplicationLinkService applicationLinkService, CacheManager cacheManager, I18nService i18nService, JenkinsBuildServerSignatureValidator jenkinsBuildServerSignatureValidator) {
        this.applicationLinkService = applicationLinkService;
        this.i18nService = i18nService;
        this.jenkinsBuildServerSignatureValidator = jenkinsBuildServerSignatureValidator;
        CacheSettings cacheSettings = new CacheSettingsBuilder().local().flushable().expireAfterWrite(8L, TimeUnit.HOURS).build();
        this.publicKeyCache = cacheManager.getCache(JenkinsBuildServerProvider.class.getName(), (CacheLoader)new JenkinsPublicKeyCacheLoader(applicationLinkService, new HttpHeaderFetcher()), cacheSettings);
    }

    public Optional<PluginBuildServer> getBuildServer(@Nonnull String id) {
        Objects.requireNonNull(id, "id");
        return MoreStreams.streamIterable((Iterable)this.applicationLinkService.getApplicationLinks(GenericApplicationType.class)).filter(applink -> applink.getRpcUrl().toString().equalsIgnoreCase(id)).findFirst().map(applicationLink -> new JenkinsPluginBuildServer((ApplicationLink)applicationLink, this.i18nService));
    }

    @Nonnull
    public Optional<PluginBuildServer> getBuildServer(@Nonnull HttpServletRequest servletRequest, @Nonnull Map<String, Object> requestBody) {
        Objects.requireNonNull(servletRequest, "servletRequest");
        Objects.requireNonNull(requestBody, "requestBody");
        String signature = servletRequest.getHeader(SIGNATURE_HEADER);
        String requestHost = this.getRequestHost(servletRequest);
        if (!StringUtils.isBlank((CharSequence)signature) && !StringUtils.isBlank((CharSequence)requestHost)) {
            return MoreStreams.streamIterable((Iterable)this.applicationLinkService.getApplicationLinks(GenericApplicationType.class)).filter(applink -> this.verifySignature((ApplicationLink)applink, servletRequest, requestBody, signature, requestHost)).findFirst().map(applicationLink -> new JenkinsPluginBuildServer((ApplicationLink)applicationLink, this.i18nService));
        }
        return Optional.empty();
    }

    private String getRequestHost(HttpServletRequest servletRequest) {
        String baseUriHeader = servletRequest.getHeader(BASE_URL_HEADER);
        if (StringUtils.isBlank((CharSequence)baseUriHeader)) {
            return null;
        }
        try {
            return new URI(baseUriHeader).getHost();
        }
        catch (URISyntaxException e) {
            String errorString = "Failed to construct URI from Jenkins request header field <base-url> " + baseUriHeader + " :";
            log.warn(errorString, (Object)e.getMessage());
            return null;
        }
    }

    private boolean verifySignature(ApplicationLink applicationLink, HttpServletRequest servletRequest, Map<String, Object> requestBody, String expectedSignature, String requestHost) {
        if (!applicationLink.getRpcUrl().getHost().equals(requestHost)) {
            return false;
        }
        try {
            PublicKey publicKey = (PublicKey)this.publicKeyCache.get((Object)applicationLink.getId());
            if (publicKey == null) {
                return false;
            }
            String algorithm = servletRequest.getHeader(ALGORITHM_HEADER);
            return this.jenkinsBuildServerSignatureValidator.doSignaturesMatch(algorithm, publicKey, requestBody, expectedSignature);
        }
        catch (CacheException e) {
            log.warn("An error occurred when trying to fetch the public key from Jenkins", (Throwable)e);
            return false;
        }
        catch (GeneralSecurityException gse) {
            log.warn("Failed to verify signature: ", (Throwable)gse);
            return false;
        }
    }

    @VisibleForTesting
    static class JenkinsPublicKeyCacheLoader
    implements CacheLoader<ApplicationId, PublicKey> {
        public static final Base64.Decoder DECODER = Base64.getDecoder();
        public static final String KEY_FACTORY_ALGORITHM = "RSA";
        public static final String PUBLIC_KEY_HEADER = "X-Instance-Identity";
        private static final Logger log = LoggerFactory.getLogger(JenkinsPublicKeyCacheLoader.class);
        private final ApplicationLinkService applicationLinkService;
        private final HttpHeaderFetcher httpHeaderFetcher;

        JenkinsPublicKeyCacheLoader(ApplicationLinkService applicationLinkService, HttpHeaderFetcher httpHeaderFetcher) {
            this.applicationLinkService = applicationLinkService;
            this.httpHeaderFetcher = httpHeaderFetcher;
        }

        @Nonnull
        public PublicKey load(@Nonnull ApplicationId applicationId) {
            try {
                String rpcUrl = this.applicationLinkService.getApplicationLink(applicationId).getRpcUrl().toString();
                Optional<String> publicKeyHeader = this.httpHeaderFetcher.getHeaderValue(rpcUrl + "/login", PUBLIC_KEY_HEADER);
                String publicKeyString = publicKeyHeader.orElseThrow(() -> new IOException("No header found for " + rpcUrl));
                return KeyFactory.getInstance(KEY_FACTORY_ALGORITHM).generatePublic(new X509EncodedKeySpec(DECODER.decode(publicKeyString)));
            }
            catch (TypeNotInstalledException | IOException | IllegalArgumentException | URISyntaxException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                log.warn("Unable to load Jenkins public key for applicationId: {}", (Object)applicationId, (Object)e);
                throw new CacheException("Failed to fetch public key from Jenkins please ensure your application link is configured correctly", e);
            }
        }
    }
}

