/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.jenkins;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsBuildServerSignatureValidator {
    private static final Logger log = LoggerFactory.getLogger(JenkinsBuildServerSignatureValidator.class);
    private final Base64.Decoder decoder = Base64.getDecoder();

    public boolean doSignaturesMatch(@Nonnull String algorithm, @Nonnull PublicKey publicKey, Map<String, Object> requestBody, String expectedSignature) throws GeneralSecurityException {
        Objects.requireNonNull(publicKey, "publicKey");
        Objects.requireNonNull(algorithm, "algorithm");
        Objects.requireNonNull(requestBody, "requestBody");
        Signature signature = Signature.getInstance(algorithm);
        signature.initVerify(publicKey);
        this.updateSignatureComponent(requestBody.get("key"), signature);
        this.updateSignatureComponent(requestBody.get("ref"), signature);
        this.updateSignatureComponent(requestBody.get("state"), signature);
        this.updateSignatureComponent(requestBody.get("url"), signature);
        return signature.verify(this.decoder.decode(expectedSignature));
    }

    private void updateSignatureComponent(@Nullable Object value, Signature signature) {
        try {
            if (value != null) {
                signature.update(value.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (SignatureException e) {
            log.warn("Failed to update signature: ", (Throwable)e);
        }
    }
}

