/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.jenkins;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bitbucket.build.server.BuildStatusEnricher;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.internal.build.jenkins.JenkinsUrlHelper;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class JenkinsBuildStatusEnricher
implements BuildStatusEnricher {
    private final ApplicationLink applicationLink;

    public JenkinsBuildStatusEnricher(@Nonnull ApplicationLink applicationLink) {
        this.applicationLink = Objects.requireNonNull(applicationLink, "applicationLink");
    }

    @Nonnull
    public Optional<URI> getArtifactLink(@Nonnull RepositoryBuildStatus buildStatus) {
        Objects.requireNonNull(buildStatus, "buildStatus");
        if (!buildStatus.getBuildNumber().isPresent()) {
            return Optional.empty();
        }
        URI resultUrl = URI.create(StringUtils.appendIfMissing((String)this.applicationLink.getRpcUrl().toString(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + JenkinsUrlHelper.getBuildStatusUrl(buildStatus) + "/ws");
        return Optional.of(resultUrl);
    }

    @Nonnull
    public Optional<URI> getLogLink(@Nonnull RepositoryBuildStatus buildStatus) {
        Objects.requireNonNull(buildStatus, "buildStatus");
        if (!buildStatus.getBuildNumber().isPresent()) {
            return Optional.empty();
        }
        URI resultUrl = URI.create(StringUtils.appendIfMissing((String)this.applicationLink.getRpcUrl().toString(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + JenkinsUrlHelper.getBuildStatusUrl(buildStatus) + "/console");
        return Optional.of(resultUrl);
    }
}

