/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.jenkins;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.bitbucket.build.server.operations.ActionResult;
import com.atlassian.bitbucket.build.server.operations.ActionState;
import com.atlassian.bitbucket.build.server.operations.BuildOperations;
import com.atlassian.bitbucket.build.server.operations.BuildStatusAction;
import com.atlassian.bitbucket.build.server.operations.BuildStatusActionRequest;
import com.atlassian.bitbucket.build.server.operations.PluginBuildServerClient;
import com.atlassian.bitbucket.build.status.BuildServer;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.build.jenkins.JenkinsActionResult;
import com.atlassian.bitbucket.internal.build.jenkins.JenkinsBuildOperations;
import com.atlassian.bitbucket.internal.build.jenkins.JenkinsUrlHelper;
import com.atlassian.bitbucket.internal.build.jenkins.model.ScheduleBuildAction;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsPluginBuildServerClient
implements PluginBuildServerClient {
    private static final Logger log = LoggerFactory.getLogger(JenkinsPluginBuildServerClient.class);
    private final ApplicationLink applicationLink;
    private final I18nService i18nService;

    public JenkinsPluginBuildServerClient(ApplicationLink applicationLink, I18nService i18nService) {
        this.applicationLink = applicationLink;
        this.i18nService = i18nService;
    }

    @Nonnull
    public Optional<BuildStatusAction> getAction(@Nonnull RepositoryBuildStatus buildStatus, @Nonnull String actionId) {
        if (this.buildStatusIsActionable(buildStatus) && ScheduleBuildAction.ID.equals(actionId)) {
            return Optional.of(new ScheduleBuildAction(this.i18nService));
        }
        return Optional.empty();
    }

    @Nonnull
    public URI getAuthorizationUrl(@Nonnull URI callback) {
        return this.applicationLink.createAuthenticatedRequestFactory().getAuthorisationURI(callback);
    }

    @Nonnull
    public URI getAuthorizationUrl() {
        return this.applicationLink.createAuthenticatedRequestFactory().getAuthorisationURI();
    }

    @Nonnull
    public BuildOperations getOperations(@Nonnull RepositoryBuildStatus buildStatus) {
        Objects.requireNonNull(buildStatus, "buildStatus");
        JenkinsBuildOperations.Builder builder = new JenkinsBuildOperations.Builder();
        try {
            ApplicationLinkRequest request = this.applicationLink.createAuthenticatedRequestFactory().createRequest(Request.MethodType.GET, JenkinsUrlHelper.getBuildStatusUrl(buildStatus) + "/api/json");
            request.execute(response -> {
                if (response.isSuccessful()) {
                    builder.actions(new ScheduleBuildAction(this.i18nService));
                } else if (JenkinsPluginBuildServerClient.requiresAuthentication(response)) {
                    builder.isAuthorizationRequired(true);
                }
            });
        }
        catch (CredentialsRequiredException e) {
            builder.isAuthorizationRequired(true);
        }
        catch (ResponseException e) {
            log.debug("Error calling out to remote Jenkins instance ({}, {})", new Object[]{this.applicationLink.getName(), this.applicationLink.getId(), e});
        }
        return builder.build();
    }

    public boolean isAuthorizationRequired() {
        try {
            return (Boolean)this.applicationLink.createAuthenticatedRequestFactory().createRequest(Request.MethodType.GET, "/bbs-oauth/authorize").executeAndReturn(JenkinsPluginBuildServerClient::requiresAuthentication);
        }
        catch (CredentialsRequiredException e) {
            return true;
        }
        catch (ResponseException e) {
            log.debug("Error calling out to remote Jenkins instance ({}, {})", new Object[]{this.applicationLink.getName(), this.applicationLink.getId(), e});
            return false;
        }
    }

    @Nonnull
    public ActionResult performAction(@Nonnull BuildStatusActionRequest request) {
        BuildStatusAction buildStatusAction = request.getBuildAction();
        RepositoryBuildStatus buildStatus = request.getBuildStatus();
        if (buildStatusAction instanceof ScheduleBuildAction) {
            BuildServer buildServer = (BuildServer)buildStatus.getBuildServer().orElseThrow(() -> new IllegalStateException(String.format("New build server present on the '%s' action request.", request.getBuildAction().getName())));
            try {
                ApplicationLinkRequest applicationLinkRequest = (ApplicationLinkRequest)this.applicationLink.createAuthenticatedRequestFactory().createRequest(Request.MethodType.POST, JenkinsUrlHelper.getJobUrl(buildStatus) + "/build").addHeader("Content-Length", "0");
                return (ActionResult)applicationLinkRequest.executeAndReturn(response -> {
                    if (response.isSuccessful()) {
                        return new JenkinsActionResult.Builder(ActionState.SUCCESSFUL).message(this.i18nService.getText("bitbucket.build.jenkins.action.schedule.success", "Action successfully executed", new Object[]{buildServer.getName()})).build();
                    }
                    log.debug("Unable to initiate action {} on {}: {} {}", new Object[]{buildStatusAction.getId(), this.applicationLink.getName(), response.getStatusCode(), response.getStatusText()});
                    if (log.isTraceEnabled()) {
                        try {
                            log.trace("Request body: {}", (Object)response.getResponseBodyAsString());
                        }
                        catch (ResponseException ignored) {
                            log.trace("Unable to read response body.");
                        }
                    }
                    return new JenkinsActionResult.Builder(ActionState.FAILED).message(this.i18nService.getText("bitbucket.build.jenkins.action.schedule.failed", "Failed to execute action", new Object[]{buildServer.getName()})).build();
                });
            }
            catch (CredentialsRequiredException cre) {
                log.debug("Cannot perform action {} as user has not performed oauth dance ({})", (Object)buildStatusAction.getName(), (Object)cre);
                return new JenkinsActionResult.Builder(ActionState.FAILED).message(this.i18nService.getText("bitbucket.build.jenkins.action.unauthorized", "Cannot perform action as user is not authorized", new Object[0])).build();
            }
            catch (ResponseException re) {
                log.debug("Error calling out to remote Jenkins instance ({}, {})", new Object[]{this.applicationLink.getName(), this.applicationLink.getId(), re});
                return new JenkinsActionResult.Builder(ActionState.ERROR).message(this.i18nService.getText("bitbucket.build.jenkins.action.unreachable", "Error reaching remote Jenkins instance", new Object[]{buildServer.getName()})).build();
            }
        }
        return new JenkinsActionResult.Builder(ActionState.ERROR).message(this.i18nService.getText("bitbucket.build.jenkins.action.unknown", request.getBuildAction().getName(), new Object[0])).build();
    }

    private static boolean requiresAuthentication(Response response) throws ResponseException {
        return !response.isSuccessful() && response.getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode() && response.getResponseBodyAsString().contains("oauth_problem");
    }

    private boolean buildStatusIsActionable(RepositoryBuildStatus buildStatus) {
        return buildStatus.getBuildServer().map(buildServer -> "jenkins".equals(buildServer.getTypeId())).orElse(false);
    }
}

