/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.jenkins;

import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.UriUtils;

public final class JenkinsUrlHelper {
    private JenkinsUrlHelper() {
    }

    public static String getBuildStatusUrl(RepositoryBuildStatus buildStatus) {
        String jobUrl = JenkinsUrlHelper.getJobUrl(buildStatus);
        String buildNumber = buildStatus.getBuildNumber().orElse("lastBuild");
        return StringUtils.appendIfMissing((String)jobUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + buildNumber;
    }

    public static String getJobUrl(RepositoryBuildStatus buildStatus) {
        return "job/" + Arrays.stream(buildStatus.getKey().split("/")).map(fragment -> UriUtils.encodePathSegment((String)fragment, (Charset)StandardCharsets.UTF_8)).collect(Collectors.joining("/job/"));
    }
}

