/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.emoticons;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.emoticon.DmzEmoticon;
import com.atlassian.bitbucket.dmz.emoticon.DmzEmoticonService;
import com.atlassian.bitbucket.emoticons.Emoticon;
import com.atlassian.bitbucket.emoticons.EmoticonProvider;
import com.atlassian.bitbucket.emoticons.SimpleEmoticon;
import com.atlassian.bitbucket.internal.emoticons.InternalEmoticonService;
import com.atlassian.bitbucket.internal.emoticons.SimpleDmzEmoticon;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEmoticonService
implements InternalEmoticonService {
    private static final Logger log = LoggerFactory.getLogger(DefaultEmoticonService.class);
    private static final String LOCK_NAME = "emoticon.population.lock";
    private static final int MAX_EMOTICONS = 1200;
    private final DmzEmoticonService dmzEmoticonService;
    private final ExecutorService executorService;
    private final LockService lockService;
    private final NavBuilder navBuilder;
    private final TransactionTemplate transactionTemplate;
    private final Map<String, String> urlReplacements;

    public DefaultEmoticonService(@Nonnull DmzEmoticonService dmzEmoticonService, @Nonnull ExecutorService executorService, @Nonnull LockService lockService, @Nonnull NavBuilder navBuilder, @Nonnull TransactionTemplate transactionTemplate) {
        this.dmzEmoticonService = Objects.requireNonNull(dmzEmoticonService, "emoticonService");
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        this.lockService = Objects.requireNonNull(lockService, "lockService");
        this.navBuilder = Objects.requireNonNull(navBuilder, "navBuilder");
        this.transactionTemplate = Objects.requireNonNull(transactionTemplate, "transactionTemplate");
        this.urlReplacements = new HashMap<String, String>();
    }

    @Override
    public void addUrlToken(String key, String value) {
        this.urlReplacements.put(key, value);
    }

    @Override
    public void delete(@Nonnull String providerName) {
        try (LockGuard guard = LockGuard.tryLock((Lock)this.lockService.getLock(LOCK_NAME));){
            if (guard == null) {
                return;
            }
            this.executorService.execute(() -> {
                log.debug("Deleting emoticons for {}", (Object)providerName);
                int count = this.dmzEmoticonService.delete(providerName);
                log.info("Deleted {} emoticons for {}", (Object)count, (Object)providerName);
            });
        }
    }

    @Nonnull
    public Page<Emoticon> find(@Nonnull String pattern, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pattern, "pattern");
        Objects.requireNonNull(pageRequest, "pageRequest");
        return this.dmzEmoticonService.find(pattern, pageRequest).transform(this::map);
    }

    @Nonnull
    public Page<Emoticon> findAll(@Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        PageRequest restrictedPageRequest = pageRequest.buildRestrictedPageRequest(1200);
        return this.dmzEmoticonService.findAll(restrictedPageRequest).transform(this::map);
    }

    public Emoticon get(@Nonnull String shortcut) {
        return this.map(this.dmzEmoticonService.get(Objects.requireNonNull(shortcut, "shortcut")));
    }

    public List<Emoticon> getEmoticons(@Nonnull List<String> shortcuts) {
        Objects.requireNonNull(shortcuts, "shortcuts");
        return this.dmzEmoticonService.get(shortcuts).stream().map(this::map).collect(Collectors.toList());
    }

    @Override
    public void retrieve(@Nonnull EmoticonProvider provider) {
        try (LockGuard guard = LockGuard.tryLock((Lock)this.lockService.getLock(LOCK_NAME));){
            if (guard == null) {
                return;
            }
            this.executorService.execute(() -> {
                String providerName = provider.getName();
                log.debug("Start retrieving emoticons for {}", (Object)providerName);
                Map allEmoticons = provider.fetch();
                if (allEmoticons.isEmpty()) {
                    log.debug("No emoticons to save for {}", (Object)providerName);
                    return;
                }
                log.info("Saving emoticons for {}", (Object)providerName);
                this.performRetrieval(providerName, allEmoticons);
            });
        }
    }

    private static DmzEmoticon map(String providerName, Emoticon emoticon) {
        String shortcut = emoticon.getShortcut();
        if (shortcut.length() > 32) {
            log.error("Shortcut is too long for {} - trimming", (Object)emoticon);
            shortcut = shortcut.substring(0, 31);
        }
        return new SimpleDmzEmoticon.Builder(shortcut, providerName).url(emoticon.getUrl().orElse(null)).value(emoticon.getValue().orElse(null)).build();
    }

    private SimpleEmoticon map(DmzEmoticon emoticon) {
        if (emoticon == null) {
            return null;
        }
        String url = emoticon.getUrl();
        if (url != null && url.contains("::")) {
            AtomicReference<String> urlReference = new AtomicReference<String>(url);
            this.urlReplacements.forEach((key, value) -> urlReference.set(((String)urlReference.get()).replace((CharSequence)key, (CharSequence)value)));
            url = urlReference.get().replace("::BASE_URL::", this.navBuilder.buildBaseUrl());
        }
        return new SimpleEmoticon.Builder(emoticon.getId()).url(url).value(emoticon.getValue()).build();
    }

    private void performRetrieval(String providerName, Map<String, Emoticon> allEmoticons) {
        AtomicInteger count = new AtomicInteger();
        for (Collection partition : Iterables.partition(allEmoticons.values(), (int)100)) {
            this.transactionTemplate.execute(() -> {
                this.dmzEmoticonService.save((Iterable)partition.stream().map((? super T emoticon) -> DefaultEmoticonService.map(providerName, emoticon)).collect(Collectors.toList()));
                int size = partition.size();
                log.trace("Saved {} emoticons for {}", (Object)size, (Object)providerName);
                count.addAndGet(size);
                return null;
            });
        }
        log.info("Finished retrieving {} emoticons for {}", (Object)count.get(), (Object)providerName);
    }
}

