/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.emoticons;

import com.atlassian.bitbucket.emoticons.EmoticonProvider;
import com.atlassian.bitbucket.internal.emoticons.InternalEmoticonService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PreDestroy;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmoticonJobScheduler {
    private static final Logger log = LoggerFactory.getLogger(EmoticonJobScheduler.class);
    private static final long DEFAULT_RETRIEVAL_INTERVAL_MINUTES = TimeUnit.HOURS.toMinutes(8L);
    private static final String PROPERTY_PREFIX = "plugin.emoticons.";
    private static final String PROPERTY_RETRIEVAL_INTERVAL_MINUTES = "plugin.emoticons.retrieval.interval";
    private static final long DELETION_DELAY_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final long RETRIEVAL_DELAY_MILLIS = DELETION_DELAY_MILLIS + 15000L;
    private final InternalEmoticonService emoticonService;
    private final long intervalMillis;
    private final Set<JobRunnerKey> registeredJobRunners;
    private final SchedulerService schedulerService;

    public EmoticonJobScheduler(InternalEmoticonService emoticonService, ApplicationPropertiesService propertiesService, SchedulerService schedulerService) {
        this.emoticonService = emoticonService;
        this.schedulerService = schedulerService;
        long intervalMinutes = propertiesService.getPluginProperty(PROPERTY_RETRIEVAL_INTERVAL_MINUTES, DEFAULT_RETRIEVAL_INTERVAL_MINUTES);
        this.intervalMillis = TimeUnit.MINUTES.toMillis(intervalMinutes);
        this.registeredJobRunners = new HashSet<JobRunnerKey>();
    }

    @PreDestroy
    public void onStop() {
        this.registeredJobRunners.forEach(arg_0 -> ((SchedulerService)this.schedulerService).unregisterJobRunner(arg_0));
    }

    public void scheduleDeletionJob(@Nonnull EmoticonProvider provider) {
        String providerName = Objects.requireNonNull(provider, "provider").getName();
        if (!provider.isUpdatable()) {
            log.debug("Skipping deletion for {}", (Object)providerName);
            return;
        }
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)(EmoticonDeletionJobRunner.class.getName() + "-" + providerName));
        this.registeredJobRunners.add(jobRunnerKey);
        this.schedulerService.registerJobRunner(jobRunnerKey, (JobRunner)new EmoticonDeletionJobRunner(providerName, jobRunnerKey));
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(14, Ints.saturatedCast((long)DELETION_DELAY_MILLIS));
        try {
            log.debug("Scheduling emoticon deletion job for {} for {}", (Object)providerName, (Object)cal.getTime());
            this.schedulerService.scheduleJob(JobId.of((String)(EmoticonDeletionJobRunner.class.getSimpleName() + ":" + providerName)), JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce((Date)cal.getTime())));
        }
        catch (SchedulerServiceException e) {
            log.error("Failed to schedule emoticon deletion job", (Throwable)e);
        }
    }

    public void scheduleIntervalRetrievalJob(@Nonnull EmoticonProvider provider) {
        String providerName = Objects.requireNonNull(provider, "provider").getName();
        if (!provider.isUpdatable()) {
            log.debug("Skipping retrieval for {}", (Object)providerName);
            return;
        }
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)(EmoticonRetrievalJobRunner.class.getName() + "-" + providerName));
        this.registeredJobRunners.add(jobRunnerKey);
        this.schedulerService.registerJobRunner(jobRunnerKey, (JobRunner)new EmoticonRetrievalJobRunner(provider));
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(14, Ints.saturatedCast((long)RETRIEVAL_DELAY_MILLIS));
        try {
            log.debug("Scheduling emoticon retrieval job for {} for {}", (Object)providerName, (Object)cal.getTime());
            this.schedulerService.scheduleJob(JobId.of((String)(EmoticonRetrievalJobRunner.class.getSimpleName() + ":" + providerName)), JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)this.intervalMillis, (Date)cal.getTime())));
        }
        catch (SchedulerServiceException e) {
            log.error("Failed to schedule emoticon retrieval job", (Throwable)e);
        }
    }

    private class EmoticonDeletionJobRunner
    implements JobRunner {
        private final JobRunnerKey jobRunnerKey;
        private final String providerName;

        EmoticonDeletionJobRunner(@Nonnull String providerName, JobRunnerKey jobRunnerKey) {
            this.jobRunnerKey = jobRunnerKey;
            this.providerName = providerName;
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            try {
                EmoticonJobScheduler.this.emoticonService.delete(this.providerName);
                EmoticonJobScheduler.this.registeredJobRunners.remove(this.jobRunnerKey);
                EmoticonJobScheduler.this.schedulerService.unregisterJobRunner(this.jobRunnerKey);
            }
            catch (Exception e) {
                log.warn("Emoticon retrieval job failed ({})", MoreObjects.firstNonNull((Object)e.getMessage(), (Object)"no message"));
            }
            return JobRunnerResponse.success();
        }
    }

    private class EmoticonRetrievalJobRunner
    implements JobRunner {
        private final EmoticonProvider provider;

        EmoticonRetrievalJobRunner(EmoticonProvider provider) {
            this.provider = provider;
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            try {
                EmoticonJobScheduler.this.emoticonService.retrieve(this.provider);
            }
            catch (Exception e) {
                log.warn("Emoticon retrieval job failed ({})", MoreObjects.firstNonNull((Object)e.getMessage(), (Object)"no message"));
            }
            return JobRunnerResponse.success();
        }
    }
}

