/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.emoticons;

import com.atlassian.bitbucket.emoticons.EmoticonProvider;
import com.atlassian.bitbucket.internal.emoticons.EmoticonJobScheduler;
import jakarta.annotation.PreDestroy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmoticonProviderServiceTracker
implements ServiceTrackerCustomizer<EmoticonProvider, EmoticonProvider> {
    private static final Logger log = LoggerFactory.getLogger(EmoticonProviderServiceTracker.class);
    private final BundleContext bundleContext;
    private final EmoticonJobScheduler jobScheduler;
    private final ServiceTracker<EmoticonProvider, EmoticonProvider> serviceTracker;

    public EmoticonProviderServiceTracker(BundleContext bundleContext, EmoticonJobScheduler jobScheduler) {
        this.bundleContext = bundleContext;
        this.jobScheduler = jobScheduler;
        this.serviceTracker = new ServiceTracker(bundleContext, EmoticonProvider.class, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
    }

    public EmoticonProvider addingService(ServiceReference<EmoticonProvider> serviceReference) {
        EmoticonProvider provider = (EmoticonProvider)this.bundleContext.getService(serviceReference);
        if (provider == null) {
            log.debug("Failed to resolve EmoticonProvider for reference {}", serviceReference);
            return null;
        }
        this.jobScheduler.scheduleIntervalRetrievalJob(provider);
        return provider;
    }

    @PreDestroy
    public void destroy() {
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
        }
    }

    public void modifiedService(ServiceReference<EmoticonProvider> reference, EmoticonProvider provider) {
        this.jobScheduler.scheduleIntervalRetrievalJob(provider);
    }

    public void removedService(ServiceReference<EmoticonProvider> serviceReference, EmoticonProvider provider) {
        this.bundleContext.ungetService(serviceReference);
        this.jobScheduler.scheduleDeletionJob(provider);
    }
}

