/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.emoticons;

import com.atlassian.bitbucket.dmz.emoticon.DmzEmoticon;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public final class SimpleDmzEmoticon
implements DmzEmoticon {
    private final String id;
    private final String provider;
    private final String url;
    private final String value;

    private SimpleDmzEmoticon(Builder builder) {
        this.id = builder.id;
        this.provider = builder.provider;
        this.url = builder.url;
        this.value = builder.value;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getProvider() {
        return this.provider;
    }

    public String getUrl() {
        return this.url;
    }

    public String getValue() {
        return this.value;
    }

    public static class Builder
    extends BuilderSupport {
        private final String id;
        private final String provider;
        private String url;
        private String value;

        public Builder(@Nonnull String id, @Nonnull String provider) {
            this.id = Objects.requireNonNull(id, "id");
            this.provider = Objects.requireNonNull(provider, "provider");
        }

        public Builder(@Nonnull SimpleDmzEmoticon emoticon) {
            this.id = Objects.requireNonNull(emoticon, "emoticon").getId();
            this.provider = emoticon.getProvider();
            this.url = emoticon.getUrl();
            this.value = emoticon.getValue();
        }

        @Nonnull
        public SimpleDmzEmoticon build() {
            return new SimpleDmzEmoticon(this);
        }

        @Nonnull
        public Builder url(String value) {
            this.url = value;
            return this;
        }

        @Nonnull
        public Builder value(String value) {
            this.value = value;
            return this;
        }
    }
}

