/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.emoticons.emoji;

import com.atlassian.bitbucket.dmz.markup.renderer.Replacement;
import com.atlassian.bitbucket.internal.emoticons.EmoticonScanner;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

class EmojiScanner
implements EmoticonScanner {
    static final Map<String, Integer> SMILEYS = ImmutableMap.builder().put((Object)":)", (Object)128578).put((Object)":-)", (Object)128578).put((Object)"=)", (Object)128578).put((Object)":(", (Object)128577).put((Object)":-(", (Object)128577).put((Object)";-)", (Object)128521).put((Object)";)", (Object)128521).put((Object)"8)", (Object)128526).put((Object)"8-)", (Object)128526).put((Object)":p", (Object)128539).put((Object)":-p", (Object)128539).put((Object)":P", (Object)128539).put((Object)":-P", (Object)128539).put((Object)":D", (Object)128515).put((Object)":-D", (Object)128515).put((Object)":|", (Object)128528).put((Object)":-|", (Object)128528).put((Object)":o", (Object)128558).put((Object)":-o", (Object)128558).put((Object)":O", (Object)128558).put((Object)":-O", (Object)128558).put((Object)":z", (Object)128566).put((Object)":-z", (Object)128566).put((Object)";p", (Object)128540).put((Object)";-p", (Object)128540).put((Object)";P", (Object)128540).put((Object)";-P", (Object)128540).put((Object)">:-(", (Object)128545).put((Object)">:(", (Object)128545).put((Object)":'(", (Object)128546).put((Object)":#", (Object)128556).put((Object)":$", (Object)129297).put((Object)":\\", (Object)128533).put((Object)"<3", (Object)10084).put((Object)"</3", (Object)128148).build();
    private StringBuilder builder = new StringBuilder();
    private boolean canStartEmoji = true;
    private int prevIndex = -1;
    private int startIndex = -1;

    EmojiScanner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Replacement scan(int index, int codePoint) {
        try {
            if (index > this.prevIndex + 1) {
                this.reset();
            }
            if (this.startIndex > -1) {
                String shortCode = this.builder.toString();
                this.builder.appendCodePoint(codePoint);
                if (this.isPossible(shortCode)) {
                    Replacement replacement = this.getReplacement(shortCode);
                    if (replacement != null) {
                        this.reset();
                        this.canStartEmoji = true;
                        this.maybeStartMatch(index, codePoint);
                        if (this.startIndex > -1 || this.isValidBoundaryChar(codePoint)) {
                            Replacement replacement2 = replacement;
                            return replacement2;
                        }
                    }
                    Replacement replacement3 = null;
                    return replacement3;
                }
                this.stripFirstCharAndRetry();
            }
            this.maybeStartMatch(index, codePoint);
            Replacement replacement = null;
            return replacement;
        }
        finally {
            this.prevIndex = index;
        }
    }

    @Override
    public Replacement onEnd() {
        return this.startIndex > -1 ? this.getReplacement(this.builder.toString()) : null;
    }

    private Replacement getReplacement(String shortCode) {
        Integer emojiCodePoint = SMILEYS.get(shortCode);
        if (emojiCodePoint == null) {
            return null;
        }
        StringBuilder emojiString = new StringBuilder();
        emojiString.appendCodePoint(emojiCodePoint);
        return new Replacement(this.startIndex, this.startIndex + shortCode.length(), (CharSequence)emojiString.toString());
    }

    private boolean isValidBoundaryChar(int codePoint) {
        return Character.isWhitespace(codePoint);
    }

    private boolean isPossible(String shortCode) {
        return SMILEYS.keySet().stream().anyMatch(key -> key.startsWith(shortCode));
    }

    private void maybeStartMatch(int index, int codePoint) {
        if (this.startIndex == -1) {
            if (this.canStartEmoji && (codePoint == 58 || codePoint == 59 || codePoint == 62 || codePoint == 60 || codePoint == 61 || codePoint == 56)) {
                this.startIndex = index;
                this.builder.appendCodePoint(codePoint);
            } else {
                this.canStartEmoji = this.isValidBoundaryChar(codePoint);
            }
        }
    }

    private void stripFirstCharAndRetry() {
        String shortCode = this.builder.toString();
        while (!(shortCode.isEmpty() || this.canStartEmoji && this.isPossible(shortCode))) {
            this.canStartEmoji = this.isValidBoundaryChar(shortCode.codePointAt(0));
            shortCode = shortCode.substring(1);
            ++this.startIndex;
        }
        this.builder.setLength(0);
        if (shortCode.isEmpty()) {
            this.startIndex = -1;
        } else {
            this.builder.append(shortCode);
        }
    }

    private void reset() {
        this.startIndex = -1;
        this.builder.setLength(0);
    }
}

