/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.emoticons.markup;

import com.atlassian.bitbucket.dmz.markup.renderer.MarkupRendererComponent;
import com.atlassian.bitbucket.dmz.markup.renderer.RenderContext;
import com.atlassian.bitbucket.dmz.markup.renderer.RenderTransform;
import com.atlassian.bitbucket.dmz.markup.renderer.Replacement;
import com.atlassian.bitbucket.internal.emoticons.EmoticonScanner;
import com.atlassian.bitbucket.internal.emoticons.EmoticonScannerFactory;
import com.atlassian.bitbucket.internal.emoticons.markup.MarkupAnalyzingIterator;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;

public class EmoticonMarkupRenderer
implements MarkupRendererComponent {
    private final List<EmoticonScannerFactory> scannerFactories;

    public EmoticonMarkupRenderer(List<EmoticonScannerFactory> scannerFactories) {
        this.scannerFactories = new ArrayList<EmoticonScannerFactory>(scannerFactories);
        OrderComparator.sort(this.scannerFactories);
    }

    @Nonnull
    public RenderTransform process(CharSequence input, @Nonnull RenderContext renderContext) {
        try (Timer ignored = TimerUtils.start((String)"emoticon transform");){
            EmoticonReplacementBuilder builder = new EmoticonReplacementBuilder(this.scannerFactories.stream().sorted(Comparator.comparing(Ordered::getOrder)).map(EmoticonScannerFactory::create).collect(Collectors.toList()));
            int index = 0;
            MarkupAnalyzingIterator it = new MarkupAnalyzingIterator(input.codePoints().iterator());
            while (it.hasNext()) {
                int codePoint = it.nextInt();
                if (!it.isInCodeFragment()) {
                    builder.codePoint(index, codePoint);
                }
                index += Character.charCount(codePoint);
            }
            RenderTransform renderTransform = new RenderTransform(builder.build());
            return renderTransform;
        }
    }

    private static class EmoticonReplacementBuilder {
        private final ImmutableList.Builder<Replacement> builder;
        private final List<EmoticonScanner> scanners;
        private int lastReplacedIndex;

        private EmoticonReplacementBuilder(List<EmoticonScanner> scanners) {
            this.scanners = scanners;
            this.builder = ImmutableList.builder();
        }

        private List<Replacement> build() {
            for (EmoticonScanner scanner : this.scanners) {
                this.maybeAdd(scanner.onEnd());
            }
            return this.builder.build();
        }

        private void codePoint(int index, int codePoint) {
            for (EmoticonScanner scanner : this.scanners) {
                this.maybeAdd(scanner.scan(index, codePoint));
            }
        }

        private void maybeAdd(Replacement replacement) {
            if (replacement != null && replacement.getStart() >= this.lastReplacedIndex) {
                this.lastReplacedIndex = replacement.getEnd();
                this.builder.add((Object)replacement);
            }
        }
    }
}

