/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.emoticons.markup;

import java.util.PrimitiveIterator;

public class MarkupAnalyzingIterator
implements PrimitiveIterator.OfInt {
    private final PrimitiveIterator.OfInt delegate;
    private int[] buffer;
    private int bufWriteIndex;
    private int bufReadIndex;
    private CodeSection codeSection;
    private boolean curLineQuoted;
    private boolean escaped;
    private boolean prevLineWasBlank;
    private Integer spacesSinceLastEol;
    private Integer spacesSinceQuoteMarker;
    private Integer tabsSinceLastEol;
    private boolean whitespaceSinceLastEol;

    public MarkupAnalyzingIterator(PrimitiveIterator.OfInt delegate) {
        this.delegate = delegate;
        this.buffer = new int[16];
        this.bufReadIndex = 0;
        this.bufWriteIndex = 0;
        this.spacesSinceLastEol = null;
        this.tabsSinceLastEol = null;
    }

    @Override
    public int nextInt() {
        int ch;
        if (this.codeSection != null) {
            this.codeSection = this.codeSection.getNext();
        }
        if (this.bufWriteIndex > 0) {
            ch = this.buffer[this.bufReadIndex];
            if (++this.bufReadIndex == this.bufWriteIndex) {
                this.bufWriteIndex = 0;
                this.bufReadIndex = 0;
            }
        } else {
            ch = this.delegate.nextInt();
            if (!this.escaped) {
                if (ch == 96) {
                    this.detectBackTickCodeBlock();
                } else if (ch == 126) {
                    this.detectTildeCodeBlock();
                } else if (ch == 62) {
                    this.detectQuoteBlock();
                }
            }
        }
        boolean bl = this.escaped = ch == 92 && !this.escaped;
        if (ch == 10 || ch == 13) {
            this.prevLineWasBlank = this.whitespaceSinceLastEol;
            this.whitespaceSinceLastEol = true;
            this.spacesSinceLastEol = 0;
            this.tabsSinceLastEol = 0;
        } else {
            if (ch == 32 && (this.spacesSinceLastEol != null || this.spacesSinceQuoteMarker != null)) {
                int newSpaces;
                if (this.spacesSinceQuoteMarker != null) {
                    newSpaces = this.spacesSinceQuoteMarker + 1;
                    this.spacesSinceQuoteMarker = newSpaces;
                } else {
                    newSpaces = this.spacesSinceLastEol + 1;
                    this.spacesSinceLastEol = newSpaces;
                }
                if (this.prevLineWasBlank && newSpaces == 4 && this.codeSection == null) {
                    this.codeSection = new CodeSection(CodeSectionType.INDENT_BLOCK, this.curLineQuoted);
                }
            }
            if (ch == 9 && this.tabsSinceLastEol != null) {
                this.tabsSinceLastEol = this.tabsSinceLastEol + 1;
                if (this.prevLineWasBlank && this.tabsSinceLastEol > 0 && this.codeSection == null) {
                    this.codeSection = new CodeSection(CodeSectionType.INDENT_BLOCK, this.curLineQuoted);
                }
            }
            this.maybeEndIndentBlock(ch);
            if (!Character.isWhitespace(ch)) {
                if (this.spacesSinceQuoteMarker != null && (this.spacesSinceQuoteMarker != 0 || ch != 62)) {
                    this.spacesSinceQuoteMarker = null;
                }
                this.whitespaceSinceLastEol = false;
                this.spacesSinceLastEol = null;
                this.tabsSinceLastEol = null;
            }
        }
        return ch;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public boolean isInCodeFragment() {
        return this.codeSection != null;
    }

    private int addToBuffer(int value) {
        this.buffer[this.bufWriteIndex++] = value;
        if (this.bufWriteIndex == this.buffer.length && this.bufWriteIndex <= 1024) {
            int[] larger = new int[this.bufWriteIndex * 2];
            System.arraycopy(this.buffer, 0, larger, 0, this.buffer.length);
            this.buffer = larger;
        }
        return value;
    }

    private void detectBackTickCodeBlock() {
        if (this.codeSection != null && this.codeSection.type == CodeSectionType.INLINE_CODE) {
            this.codeSection = null;
            return;
        }
        if (this.codeSection == null || this.codeSection.type == CodeSectionType.BACKTICK_BLOCK) {
            int backTicks = 1;
            int ch = 96;
            while (this.delegate.hasNext() && ch == 96 && this.bufWriteIndex < this.buffer.length) {
                ch = this.addToBuffer(this.delegate.nextInt());
                if (ch != 96) continue;
                ++backTicks;
            }
            if (this.isCodeFence(backTicks)) {
                if (this.codeSection == null) {
                    this.codeSection = new CodeSection(CodeSectionType.BACKTICK_BLOCK, this.curLineQuoted);
                } else {
                    while (ch != 10 && Character.isWhitespace(ch) && this.delegate.hasNext() && this.bufWriteIndex < this.buffer.length) {
                        ch = this.addToBuffer(this.delegate.nextInt());
                        if (ch == 10) continue;
                        ++backTicks;
                    }
                    if (ch == 10) {
                        this.codeSection = this.codeSection.endsAfter(backTicks);
                    }
                }
            } else if (this.codeSection == null) {
                this.codeSection = backTicks % 2 == 1 ? new CodeSection(CodeSectionType.INLINE_CODE, this.curLineQuoted) : new CodeSection(CodeSectionType.INLINE_CODE, backTicks, this.curLineQuoted);
            }
        }
    }

    private void detectTildeCodeBlock() {
        if (this.codeSection == null || this.codeSection.type == CodeSectionType.TILDE_BLOCK) {
            int tildes = 1;
            int ch = 126;
            while (this.delegate.hasNext() && ch == 126 && this.bufWriteIndex < this.buffer.length) {
                ch = this.addToBuffer(this.delegate.nextInt());
                if (ch != 126) continue;
                ++tildes;
            }
            if (this.isCodeFence(tildes)) {
                if (this.codeSection == null) {
                    this.codeSection = new CodeSection(CodeSectionType.TILDE_BLOCK, this.curLineQuoted);
                } else {
                    while (ch != 10 && Character.isWhitespace(ch) && this.delegate.hasNext() && this.bufWriteIndex < this.buffer.length) {
                        ch = this.addToBuffer(this.delegate.nextInt());
                        if (ch == 10) continue;
                        ++tildes;
                    }
                    if (ch == 10) {
                        this.codeSection = this.codeSection.endsAfter(tildes);
                    }
                }
            }
        }
    }

    private void detectQuoteBlock() {
        if (this.spacesSinceQuoteMarker == null && this.spacesSinceLastEol != null && this.spacesSinceLastEol < 4) {
            this.spacesSinceQuoteMarker = 0;
            this.curLineQuoted = true;
        }
    }

    private boolean isCodeFence(int count) {
        Integer spaces = this.codeSection != null && !this.codeSection.quoted || this.spacesSinceQuoteMarker == null ? this.spacesSinceLastEol : this.spacesSinceQuoteMarker;
        return count >= 3 && spaces != null && spaces < 4;
    }

    private void maybeEndIndentBlock(int ch) {
        if (this.codeSection == null || this.codeSection.type != CodeSectionType.INDENT_BLOCK || Character.isWhitespace(ch)) {
            return;
        }
        boolean endIt = false;
        if (this.codeSection.quoted) {
            if (this.spacesSinceQuoteMarker != null && this.spacesSinceQuoteMarker < 5 && (ch != 62 || this.spacesSinceQuoteMarker != 0)) {
                endIt = true;
            } else if (this.spacesSinceQuoteMarker == null && this.spacesSinceLastEol != null) {
                endIt = true;
            }
        } else {
            boolean bl = endIt = this.spacesSinceLastEol != null && this.spacesSinceLastEol < 4 && this.tabsSinceLastEol != null && this.tabsSinceLastEol == 0;
        }
        if (endIt) {
            this.codeSection = null;
        }
    }

    private static class CodeSection {
        private final boolean quoted;
        private final CodeSectionType type;
        private final int remainingLength;

        private CodeSection(CodeSectionType type, int remainingLength, boolean quoted) {
            this.quoted = quoted;
            this.remainingLength = remainingLength;
            this.type = type;
        }

        private CodeSection(CodeSectionType type, boolean quoted) {
            this(type, -1, quoted);
        }

        private CodeSection endsAfter(int length) {
            return new CodeSection(this.type, length, this.quoted);
        }

        private CodeSection getNext() {
            if (this.remainingLength == -1) {
                return this;
            }
            if (this.remainingLength > 1) {
                return new CodeSection(this.type, this.remainingLength - 1, this.quoted);
            }
            return null;
        }
    }

    private static enum CodeSectionType {
        INLINE_CODE(false),
        BACKTICK_BLOCK(true),
        INDENT_BLOCK(true),
        TILDE_BLOCK(true);

        private boolean block;

        private CodeSectionType(boolean block) {
            this.block = block;
        }

        public boolean isBlock() {
            return this.block;
        }
    }
}

