/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.emoticons.plugin;

import com.atlassian.bitbucket.dmz.markup.renderer.Replacement;
import com.atlassian.bitbucket.emoticons.Emoticon;
import com.atlassian.bitbucket.internal.emoticons.EmoticonScanner;
import com.atlassian.bitbucket.internal.emoticons.InternalEmoticonService;
import java.util.Optional;

class PluginEmoticonScanner
implements EmoticonScanner {
    private final InternalEmoticonService emoticonService;
    private final StringBuilder shortCodeBuilder;
    private int closeChar;
    private int prevIndex;
    private int startIndex;

    PluginEmoticonScanner(InternalEmoticonService emoticonService) {
        this.emoticonService = emoticonService;
        this.closeChar = -1;
        this.shortCodeBuilder = new StringBuilder();
        this.startIndex = -1;
        this.prevIndex = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Replacement scan(int index, int codePoint) {
        try {
            if (index > this.prevIndex + 1) {
                this.resetScanner();
            }
            if (this.startIndex == -1) {
                if (58 == codePoint) {
                    this.startIndex = index;
                    this.closeChar = 58;
                }
            } else {
                if (this.closeChar == codePoint) {
                    String shortCode = this.shortCodeBuilder.toString();
                    Replacement replacement = Optional.ofNullable(this.emoticonService.get(shortCode)).flatMap(Emoticon::getUrl).map(url -> new Replacement(this.startIndex, index + 1, (CharSequence)this.imgTag(shortCode, (String)url))).orElse(null);
                    this.resetScanner();
                    Replacement replacement2 = replacement;
                    return replacement2;
                }
                if (this.isLegal(codePoint) && index - this.startIndex <= 512) {
                    this.shortCodeBuilder.appendCodePoint(codePoint);
                } else {
                    this.resetScanner();
                }
            }
            Replacement replacement = null;
            return replacement;
        }
        finally {
            this.prevIndex = index;
        }
    }

    private String imgTag(String shortCode, String url) {
        return "<img class=\"plugin-emote-img\" src=\"" + url + "\" title=\"" + shortCode + "\"/>";
    }

    private boolean isLegal(int codePoint) {
        return codePoint >= 48 && codePoint <= 57 || codePoint >= 97 && codePoint <= 122 || codePoint == 45 || codePoint == 95 || codePoint == 43;
    }

    private void resetScanner() {
        this.closeChar = -1;
        this.startIndex = -1;
        this.shortCodeBuilder.setLength(0);
    }
}

