/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.emoticons.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.emoticons.Emoticon;
import com.atlassian.bitbucket.internal.emoticons.InternalEmoticonService;
import com.atlassian.bitbucket.internal.emoticons.rest.RestEmoticon;
import com.atlassian.bitbucket.internal.emoticons.rest.RestEmoticons;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

@UnrestrictedAccess
@Path(value="/")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class EmoticonResource {
    private final InternalEmoticonService emoticonService;

    @Inject
    public EmoticonResource(@Nonnull InternalEmoticonService emoticonService) {
        this.emoticonService = Objects.requireNonNull(emoticonService, "emoticonService");
    }

    @GET
    @Path(value="search")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response find(@QueryParam(value="query") @Nonnull String query, @BeanParam PageRequestResolver pageRequestResolver) {
        return ResponseFactory.ok((Object)new RestPage(this.emoticonService.find(query, pageRequestResolver.getPageRequest()), RestEmoticon::new)).build();
    }

    @GET
    @Path(value="emoticons")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getEmoticons(@QueryParam(value="shortcut") List<String> shortcuts) {
        if (!CollectionUtils.isEmpty(shortcuts)) {
            return ResponseFactory.ok((Object)ImmutableMap.of((Object)"values", this.emoticonService.getEmoticons(shortcuts).stream().map(RestEmoticon::new).collect(Collectors.toList()))).build();
        }
        return ResponseFactory.ok((Object)((Object)new RestEmoticons((Map)this.emoticonService.findAll((PageRequest)new PageRequestImpl(0, 1200)).stream().collect(MoreCollectors.toImmutableMap(Emoticon::getShortcut, Function.identity()))))).build();
    }
}

