/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.authentication;

import com.google.common.cache.LoadingCache;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureAdRefreshTokenFilter
implements ClientRequestFilter,
ClientResponseFilter {
    public static final String AZURE_AD_TOKEN_CACHE_KEY = "AZURE_AD_TOKEN";
    private static final Logger log = LoggerFactory.getLogger(AzureAdRefreshTokenFilter.class);
    private final LoadingCache<String, String> tokenCache;

    public AzureAdRefreshTokenFilter(LoadingCache<String, String> tokenCache) {
        this.tokenCache = tokenCache;
    }

    public void filter(ClientRequestContext request) throws IOException {
        if (!request.getHeaders().containsKey((Object)"Authorization")) {
            this.setTokenInRequest(request);
        }
    }

    public void filter(ClientRequestContext request, ClientResponseContext response) throws IOException {
        if (response.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            this.invalidateToken();
        }
    }

    private void invalidateToken() {
        this.tokenCache.invalidate((Object)AZURE_AD_TOKEN_CACHE_KEY);
    }

    public void setTokenInRequest(ClientRequestContext request) {
        String newAzureAdToken = (String)this.tokenCache.getUnchecked((Object)AZURE_AD_TOKEN_CACHE_KEY);
        request.getHeaders().putSingle((Object)"Authorization", (Object)newAzureAdToken);
    }
}

