/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.rest;

import com.atlassian.crowd.directory.query.GraphQuery;
import com.atlassian.crowd.directory.query.MicrosoftGraphQueryParam;
import com.atlassian.crowd.directory.query.ODataSelect;
import com.atlassian.crowd.directory.query.ODataTop;
import com.atlassian.crowd.directory.rest.ClientUtils;
import com.atlassian.crowd.directory.rest.endpoint.AzureApiUriResolver;
import com.atlassian.crowd.directory.rest.entity.GraphDirectoryObjectList;
import com.atlassian.crowd.directory.rest.entity.PageableGraphList;
import com.atlassian.crowd.directory.rest.entity.delta.GraphDeltaQueryGroupList;
import com.atlassian.crowd.directory.rest.entity.delta.GraphDeltaQueryUserList;
import com.atlassian.crowd.directory.rest.entity.group.GraphGroupList;
import com.atlassian.crowd.directory.rest.entity.user.GraphUsersList;
import com.atlassian.crowd.directory.rest.util.IoUtilsWrapper;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.security.xml.SecureXmlParserFactory;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AzureAdRestClient {
    private static final Logger log = LoggerFactory.getLogger(AzureAdRestClient.class);
    public static final String GRAPH_API_VERSION = "/v1.0";
    public static final String GRAPH_USERS_ENDPOINT_SUFFIX = "users";
    public static final String GRAPH_GROUPS_ENDPOINT_SUFFIX = "groups";
    public static final String METADATA_ENDPOINT_SUFFIX = "$metadata";
    public static final String MEMBER_OF_NAVIGATIONAL_PROPERTY = "memberOf";
    public static final String MEMBERS_NAVIGATIONAL_PROPERTY = "members";
    public static final String DELTA_QUERY_ENDPOINT_SUFFIX = "delta";
    public static final String TRASH_ENDPOINT_SUFFIX = "directory/deleteditems";
    private static final String SCHEMA_XPATH = "/Edmx/DataServices/Schema";
    private static final String DELTA_RETURN_PATHS_XPATH = "/Edmx/DataServices/Schema/Function[@Name='delta']/ReturnType";
    private static final String CHARSET_PARAMETER_NAME = "charset";
    private static final String ALIAS_ATTRIBUTE_NAME = "Alias";
    private static final String RETURN_TYPE_ATTRIBUTE_NAME = "Type";
    private static final String NAMESPACE_ATTRIBUTE_NAME = "Namespace";
    public static final String COLLECTION_TYPE_FORMAT = "Collection(%s.%s)";
    public static final String USER_SUFFIX = "user";
    public static final String GROUP_SUFFIX = "group";
    public static final int ATTEMPTS = 2;
    private final Client client;
    private final String graphBaseEndpoint;
    private final IoUtilsWrapper ioUtilsWrapper;

    @VisibleForTesting
    public Client getClient() {
        return this.client;
    }

    @SuppressFBWarnings(value={"XPATH_INJECTION"}, justification="No user input processed")
    public AzureAdRestClient(Client client, AzureApiUriResolver endpointDataProvider, IoUtilsWrapper ioUtilsWrapper) {
        this.client = client;
        this.graphBaseEndpoint = endpointDataProvider.getGraphApiUrl();
        this.ioUtilsWrapper = ioUtilsWrapper;
    }

    public GraphUsersList searchUsers(GraphQuery query) throws OperationFailedException {
        return (GraphUsersList)this.handleInvocation(this.client.target(this.getGraphBaseResource()).path(GRAPH_USERS_ENDPOINT_SUFFIX).queryParam(query.getFilter().getName(), new Object[]{query.getFilter().asRawValue()}).queryParam(query.getSelect().getName(), new Object[]{query.getSelect().asRawValue()}).queryParam(query.getLimit().getName(), new Object[]{query.getLimit().asRawValue()}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildGet()).readEntity(GraphUsersList.class);
    }

    public GraphGroupList searchGroups(GraphQuery query) throws OperationFailedException {
        return (GraphGroupList)this.handleInvocation(this.client.target(this.getGraphBaseResource()).path(GRAPH_GROUPS_ENDPOINT_SUFFIX).queryParam(query.getFilter().getName(), new Object[]{query.getFilter().asRawValue()}).queryParam(query.getSelect().getName(), new Object[]{query.getSelect().asRawValue()}).queryParam(query.getLimit().getName(), new Object[]{query.getLimit().asRawValue()}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildGet()).readEntity(GraphGroupList.class);
    }

    public GraphDirectoryObjectList getDirectParentsOfUser(String nameOrExternalId, ODataSelect select) throws OperationFailedException {
        return (GraphDirectoryObjectList)this.handleInvocation(this.client.target(this.getGraphBaseResource()).path(GRAPH_USERS_ENDPOINT_SUFFIX).path(nameOrExternalId).path(MEMBER_OF_NAVIGATIONAL_PROPERTY).queryParam(ODataTop.FULL_PAGE.getName(), new Object[]{ODataTop.FULL_PAGE.asRawValue()}).queryParam(select.getName(), new Object[]{select.asRawValue()}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildGet()).readEntity(GraphDirectoryObjectList.class);
    }

    public GraphDirectoryObjectList getDirectParentsOfGroup(String groupId, ODataSelect select) throws OperationFailedException {
        return (GraphDirectoryObjectList)this.handleInvocation(this.client.target(this.getGraphBaseResource()).path(GRAPH_GROUPS_ENDPOINT_SUFFIX).path(groupId).path(MEMBER_OF_NAVIGATIONAL_PROPERTY).queryParam(ODataTop.FULL_PAGE.getName(), new Object[0]).queryParam(select.getName(), new Object[]{select.asRawValue()}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildGet()).readEntity(GraphDirectoryObjectList.class);
    }

    public GraphDirectoryObjectList getDirectChildrenOfGroup(String groupId, ODataSelect select) throws OperationFailedException {
        return (GraphDirectoryObjectList)this.handleInvocation(this.client.target(this.getGraphBaseResource()).path(GRAPH_GROUPS_ENDPOINT_SUFFIX).path(groupId).path(MEMBERS_NAVIGATIONAL_PROPERTY).queryParam(select.getName(), new Object[]{select.asRawValue()}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildGet()).readEntity(GraphDirectoryObjectList.class);
    }

    public GraphDeltaQueryUserList performUsersDeltaQuery(MicrosoftGraphQueryParam parameter) throws OperationFailedException {
        return (GraphDeltaQueryUserList)this.handleInvocation(this.client.target(this.getGraphBaseResource()).path(GRAPH_USERS_ENDPOINT_SUFFIX).path(DELTA_QUERY_ENDPOINT_SUFFIX).queryParam(parameter.getName(), new Object[]{parameter.asRawValue()}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildGet()).readEntity(GraphDeltaQueryUserList.class);
    }

    public GraphDeltaQueryGroupList performGroupsDeltaQuery(MicrosoftGraphQueryParam ... parameters) throws OperationFailedException {
        WebTarget webTarget = this.client.target(this.getGraphBaseResource()).path(GRAPH_GROUPS_ENDPOINT_SUFFIX).path(DELTA_QUERY_ENDPOINT_SUFFIX);
        for (MicrosoftGraphQueryParam parameter : parameters) {
            webTarget = webTarget.queryParam(parameter.getName(), new Object[]{parameter.asRawValue()});
        }
        return (GraphDeltaQueryGroupList)this.handleInvocation(webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildGet()).readEntity(GraphDeltaQueryGroupList.class);
    }

    @SuppressFBWarnings(value={"XXE_DOCUMENT"}, justification="uses atlassian-secure-xml")
    public boolean supportsDeltaQuery() {
        try {
            log.debug("Fetching metadata from URI {}", (Object)UriBuilder.fromUri((String)this.getGraphBaseResource()).path(METADATA_ENDPOINT_SUFFIX).build(new Object[0]).toString());
            Response response = this.client.target(this.getGraphBaseResource()).path(METADATA_ENDPOINT_SUFFIX).request().get();
            this.checkStatusCode(response);
            Charset encoding = this.extractEncoding(response);
            String xmlResponseBody = (String)response.readEntity(String.class);
            Document metadataDocument = SecureXmlParserFactory.newDocumentBuilder().parse(this.ioUtilsWrapper.toInputStream(xmlResponseBody, encoding));
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPathExpression schemaXpath = xPath.compile(SCHEMA_XPATH);
            NodeList schemaNodes = (NodeList)schemaXpath.evaluate(metadataDocument, XPathConstants.NODESET);
            XPathExpression deltaGroupsQueryXpath = xPath.compile(DELTA_RETURN_PATHS_XPATH);
            NodeList deltaReturnTypes = (NodeList)deltaGroupsQueryXpath.evaluate(metadataDocument, XPathConstants.NODESET);
            return this.supportsUsersAndGroupsDeltaQuery(schemaNodes, deltaReturnTypes);
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean supportsUsersAndGroupsDeltaQuery(NodeList schemaNodes, NodeList deltaReturnTypes) {
        Set possiblePrefixes = IntStream.range(0, schemaNodes.getLength()).mapToObj(schemaNodes::item).map(node -> this.getPresentAttributeValues((Node)node, ALIAS_ATTRIBUTE_NAME, NAMESPACE_ATTRIBUTE_NAME)).flatMap(Collection::stream).collect(Collectors.toSet());
        Set userTypes = possiblePrefixes.stream().map(a -> String.format(COLLECTION_TYPE_FORMAT, a, USER_SUFFIX)).collect(Collectors.toSet());
        Set groupTypes = possiblePrefixes.stream().map(a -> String.format(COLLECTION_TYPE_FORMAT, a, GROUP_SUFFIX)).collect(Collectors.toSet());
        Set types = IntStream.range(0, deltaReturnTypes.getLength()).mapToObj(deltaReturnTypes::item).flatMap(node -> this.getPresentAttributeValues((Node)node, RETURN_TYPE_ATTRIBUTE_NAME).stream()).collect(Collectors.toSet());
        return !Collections.disjoint(userTypes, types) && !Collections.disjoint(groupTypes, types);
    }

    private Set<String> getPresentAttributeValues(Node node, String ... names) {
        Optional<NamedNodeMap> attributes = Optional.ofNullable(node).map(Node::getAttributes);
        if (!attributes.isPresent()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String name : names) {
            attributes.map(a -> a.getNamedItem(name)).map(Node::getNodeValue).ifPresent(result::add);
        }
        return result;
    }

    private void checkStatusCode(Response response) {
        if (response.getStatus() >= 400) {
            throw new WebApplicationException("Server returned HTTP error code " + response.getStatus(), response.getStatus());
        }
    }

    private Charset extractEncoding(Response response) {
        return response.getMediaType().getParameters().entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(CHARSET_PARAMETER_NAME)).findFirst().map(entry -> Charset.forName((String)entry.getValue())).orElse(StandardCharsets.UTF_8);
    }

    @VisibleForTesting
    public String getGraphBaseResource() {
        return this.graphBaseEndpoint + GRAPH_API_VERSION;
    }

    public <T extends PageableGraphList> T getNextPage(String nextLink, Class<T> resultsClass) throws OperationFailedException {
        return (T)((PageableGraphList)this.handleInvocation(this.client.target(nextLink).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildGet()).readEntity(resultsClass));
    }

    public <T extends PageableGraphList> T getNextPage(String nextLink, Class<T> resultsClass, ODataTop limit) throws OperationFailedException {
        URI nextLinkWithUpdatedLimit = UriBuilder.fromUri((String)AzureAdRestClient.replaceQueryParam(nextLink, "$top", limit.asRawValue())).build(new Object[0]);
        return (T)((PageableGraphList)this.handleInvocation(this.client.target(nextLinkWithUpdatedLimit).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildGet()).readEntity(resultsClass));
    }

    @VisibleForTesting
    public Response handleInvocation(Invocation invocation) throws OperationFailedException {
        return this.handleInvocation(2, invocation);
    }

    @VisibleForTesting
    public Response handleInvocation(int attempts, Invocation invocation) throws OperationFailedException {
        String errorMessage = "Microsoft Graph API has returned an error response.";
        try {
            Response response = ClientUtils.invokeWithRetry(attempts, invocation);
            if (response == null) {
                throw new OperationFailedException(errorMessage);
            }
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                String responseBody = response.hasEntity() ? (String)response.readEntity(String.class) : "null";
                throw new OperationFailedException(String.format("%s Response status code: %d, content %s", errorMessage, response.getStatus(), responseBody));
            }
            return response;
        }
        catch (ProcessingException e) {
            throw new OperationFailedException("Microsoft Graph API has returned an error response.", (Throwable)e);
        }
    }

    static String replaceQueryParam(String uri, String param, String newValue) {
        return uri.replaceFirst(Pattern.quote(param) + "=[^&]*", Matcher.quoteReplacement(param + "=" + newValue));
    }
}

