/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.rest;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtils {
    private static final Logger log = LoggerFactory.getLogger(ClientUtils.class);

    @Nullable
    public static Response invokeWithRetry(int maxAttempts, @Nonnull Invocation invocation) {
        if (maxAttempts < 1) {
            throw new IllegalArgumentException("Number of attempts must be greater than 0");
        }
        Objects.requireNonNull(invocation, "Invocation must not be null");
        Response response = null;
        for (int attempts = 0; attempts < maxAttempts; ++attempts) {
            try {
                Response newResponse = invocation.invoke();
                ClientUtils.closeQuietly(response);
                response = newResponse;
                if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) continue;
                return response;
            }
            catch (ProcessingException e) {
                if (attempts == maxAttempts - 1 && response == null) {
                    throw e;
                }
                log.debug("Error while executing request to Microsoft Graph API. Retrying.", (Throwable)e);
            }
        }
        return response;
    }

    public static void closeQuietly(@Nullable Response response) {
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

