/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.rest.resolver;

import com.atlassian.crowd.directory.rest.entity.membership.DirectoryObject;
import com.atlassian.crowd.directory.rest.entity.membership.GraphMembershipGroup;
import com.atlassian.crowd.directory.rest.entity.membership.GraphMembershipUser;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class DirectoryObjectTypeIdResolver
implements TypeIdResolver {
    public static final String USER_ODATA_TYPE = "#microsoft.graph.user";
    public static final String GROUP_ODATA_TYPE = "#microsoft.graph.group";
    private static final Map<Class<?>, String> CLASSES_TO_IDS = ImmutableMap.of(GraphMembershipUser.class, (Object)"#microsoft.graph.user", GraphMembershipGroup.class, (Object)"#microsoft.graph.group");
    private Map<String, JavaType> idsToTypes;
    private JavaType baseType;
    private JavaType fallbackType;

    public void init(JavaType baseType) {
        this.baseType = baseType;
        this.idsToTypes = new ImmutableMap.Builder().put((Object)USER_ODATA_TYPE, (Object)this.constructJavaType(GraphMembershipUser.class)).put((Object)GROUP_ODATA_TYPE, (Object)this.constructJavaType(GraphMembershipGroup.class)).build();
        this.fallbackType = this.constructJavaType(DirectoryObject.class);
    }

    public String idFromValue(Object value) {
        return this.idFromValueAndType(value, value.getClass());
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return CLASSES_TO_IDS.get(suggestedType);
    }

    public String idFromBaseType() {
        return CLASSES_TO_IDS.get(this.baseType.getRawClass());
    }

    public JavaType typeFromId(DatabindContext databindContext, String id) {
        return this.idsToTypes.getOrDefault(id, this.fallbackType);
    }

    public String getDescForKnownTypeIds() {
        return String.join((CharSequence)",", CLASSES_TO_IDS.values());
    }

    private JavaType constructJavaType(Class<?> clazz) {
        try {
            return TypeFactory.defaultInstance().constructSpecializedType(this.baseType, clazz);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Cannot find class " + String.valueOf(clazz));
        }
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }
}

