/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.rpc;

import com.atlassian.bitbucket.mesh.rpc.ZeroCopyStreamCloser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UnsafeByteOperations;
import io.grpc.Detachable;
import io.grpc.HasByteBuffer;
import io.grpc.KnownLength;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.lite.GrpcProtoLiteBackdoor;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BooleanSupplier;

public class ZeroCopyMarshaller<T extends MessageLite>
implements MethodDescriptor.Marshaller<T> {
    private final BooleanSupplier enabledSupplier;
    private final MethodDescriptor.PrototypeMarshaller<T> protobufMarshaller;
    private final Parser<T> protobufParser;

    public ZeroCopyMarshaller(BooleanSupplier enabledSupplier, MethodDescriptor.PrototypeMarshaller<T> protobufMarshaller) {
        Objects.requireNonNull(enabledSupplier, "enabledSupplier");
        this.protobufMarshaller = Objects.requireNonNull(protobufMarshaller, "protobufMarshaller");
        MessageLite prototype = (MessageLite)protobufMarshaller.getMessagePrototype();
        if (prototype == null) {
            this.enabledSupplier = () -> false;
            this.protobufParser = null;
        } else {
            this.enabledSupplier = enabledSupplier;
            this.protobufParser = prototype.getParserForType();
        }
    }

    @Nonnull
    public T parse(@Nonnull InputStream stream) {
        try {
            if (this.enabledSupplier.getAsBoolean() && stream instanceof Detachable && stream instanceof KnownLength && stream instanceof HasByteBuffer && ((HasByteBuffer)stream).byteBufferSupported()) {
                ByteBuffer buffer;
                int size = stream.available();
                InputStream detached = ((Detachable)stream).detach();
                ZeroCopyStreamCloser.register(detached);
                detached.mark(size);
                ArrayList<ByteString> fragments = new ArrayList<ByteString>();
                while (detached.available() != 0 && (buffer = ((HasByteBuffer)detached).getByteBuffer()) != null) {
                    fragments.add(UnsafeByteOperations.unsafeWrap((ByteBuffer)buffer));
                    detached.skip(buffer.remaining());
                }
                CodedInputStream cis = ByteString.copyFrom(fragments).newCodedInput();
                cis.enableAliasing(true);
                cis.setSizeLimit(Integer.MAX_VALUE);
                return (T)((MessageLite)this.protobufParser.parseFrom(cis, GrpcProtoLiteBackdoor.getExtensionRegistry()));
            }
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw Status.INTERNAL.withCause((Throwable)ipbe).asRuntimeException();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (T)((MessageLite)this.protobufMarshaller.parse(stream));
    }

    public InputStream stream(T value) {
        return GrpcProtoLiteBackdoor.newProtoInputStream(value, this.protobufParser);
    }
}

