/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.rpc;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZeroCopyStreamCloser {
    public static final ThreadLocal<List<InputStream>> DETACHED_STREAMS = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(ZeroCopyStreamCloser.class);

    ZeroCopyStreamCloser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        List<InputStream> streams = DETACHED_STREAMS.get();
        try {
            if (streams != null) {
                for (InputStream inputStream : streams) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        log.error("Failed to close detached gRPC input stream. Memory may leak!", (Throwable)e);
                    }
                }
            }
        }
        finally {
            DETACHED_STREAMS.remove();
        }
    }

    static void register(InputStream inputStream) {
        List<InputStream> streams = DETACHED_STREAMS.get();
        if (streams == null) {
            streams = new ArrayList<InputStream>();
            DETACHED_STREAMS.set(streams);
        }
        streams.add(inputStream);
    }
}

