/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd;

import com.atlassian.bitbucket.internal.ipd.SchedulerServiceJobRunner;
import com.atlassian.diagnostics.internal.ipd.IpdRegistryLogger;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class IpdCollectorScheduler
implements ScheduledJobSource {
    private static final Logger log = LoggerFactory.getLogger(IpdCollectorScheduler.class);
    private static final JobId COLLECTOR_JOB_ID = JobId.of((String)(SchedulerServiceJobRunner.class.getSimpleName() + "-ipd-collector-job"));
    private static final JobRunnerKey COLLECTOR_JOB_RUNNER_KEY = JobRunnerKey.of((String)(SchedulerServiceJobRunner.class.getName() + "-ipd-collector-job"));
    @Value(value="${diagnostics.ipd.monitoring.poll.interval.seconds:60}")
    private int intervalSeconds = 60;
    private final IpdRegistryLogger ipdRegistryLogger;

    @Autowired
    public IpdCollectorScheduler(IpdRegistryLogger ipdRegistryLogger) {
        this.ipdRegistryLogger = Objects.requireNonNull(ipdRegistryLogger);
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        SchedulerServiceJobRunner jobRunner = new SchedulerServiceJobRunner(this::ipdCollectorIteration);
        schedulerService.registerJobRunner(COLLECTOR_JOB_RUNNER_KEY, (JobRunner)jobRunner);
        int delay = this.intervalSeconds / 2;
        schedulerService.scheduleJob(COLLECTOR_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)COLLECTOR_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)Duration.ofSeconds(this.intervalSeconds).toMillis(), (Date)Date.from(ZonedDateTime.now().plus(Duration.ofSeconds(delay)).toInstant()))));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unscheduleJob(COLLECTOR_JOB_ID);
        schedulerService.unregisterJobRunner(COLLECTOR_JOB_RUNNER_KEY);
    }

    @VisibleForTesting
    void ipdCollectorIteration() {
        try {
            this.ipdRegistryLogger.logRegisteredMetrics();
        }
        catch (Exception ex) {
            log.error("Unable to complete IPD data logging iteration.", (Throwable)ex);
        }
    }
}

