/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd;

import com.atlassian.bitbucket.internal.ipd.SchedulerServiceJobRunner;
import com.atlassian.diagnostics.ipd.api.CachedIpdState;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRunner;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class IpdEmitterScheduler
implements ScheduledJobSource {
    private static final JobId EMITTER_JOB_ID = JobId.of((String)(SchedulerServiceJobRunner.class.getSimpleName() + "-ipd-emitter-job"));
    private static final JobRunnerKey EMITTER_JOB_RUNNER_KEY = JobRunnerKey.of((String)(SchedulerServiceJobRunner.class.getName() + "-ipd-emitter-job"));
    private static final int EMITTER_DELAY = 0;
    private static final Logger log = LoggerFactory.getLogger(IpdEmitterScheduler.class);
    private final IpdJobRunner ipdJobRunner;
    private final IpdRegistry ipdRegistry;
    private final CachedIpdState cachedIpdState;
    @Value(value="${diagnostics.ipd.monitoring.poll.interval.seconds:60}")
    private int intervalSeconds = 60;

    public IpdEmitterScheduler(IpdJobRunner ipdJobRunner, IpdRegistry ipdRegistry, CachedIpdState cachedIpdState) {
        this.ipdJobRunner = Objects.requireNonNull(ipdJobRunner);
        this.ipdRegistry = Objects.requireNonNull(ipdRegistry);
        this.cachedIpdState = cachedIpdState;
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        SchedulerServiceJobRunner jobRunner = new SchedulerServiceJobRunner(this::ipdEmitterIteration);
        schedulerService.registerJobRunner(EMITTER_JOB_RUNNER_KEY, (JobRunner)jobRunner);
        schedulerService.scheduleJob(EMITTER_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)EMITTER_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)Duration.ofSeconds(this.intervalSeconds).toMillis(), (Date)Date.from(ZonedDateTime.now().plus(Duration.ofSeconds(0L)).toInstant()))));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unscheduleJob(EMITTER_JOB_ID);
        schedulerService.unregisterJobRunner(EMITTER_JOB_RUNNER_KEY);
    }

    @VisibleForTesting
    void ipdEmitterIteration() {
        try {
            this.cachedIpdState.refreshState();
            this.ipdRegistry.unregisterAllDisabledMetrics();
            this.ipdJobRunner.runJobs();
        }
        catch (Exception ex) {
            log.error("Unable to complete IPD emitting iteration.", (Throwable)ex);
        }
    }
}

