/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd;

import com.atlassian.bitbucket.internal.ipd.JmxLoggerService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JmxLoggerScheduler
implements ScheduledJobSource {
    private static final int FIRST_RUN_DELAY = 0;
    private static final JobId JOB_ID = JobId.of((String)JmxLoggerJobRunner.class.getSimpleName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)JmxLoggerJobRunner.class.getName());
    private final Clock clock;
    private final JmxLoggerService jmxLoggerService;
    @Value(value="${diagnostics.ipd.monitoring.poll.interval.seconds:60}")
    private final int intervalSeconds = 60;

    public JmxLoggerScheduler(Clock clock, JmxLoggerService jmxLoggerService) {
        this.jmxLoggerService = jmxLoggerService;
        this.clock = clock;
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new JmxLoggerJobRunner());
        schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)Duration.ofSeconds(60L).toMillis(), (Date)Date.from(ZonedDateTime.now(this.clock).plus(Duration.ofSeconds(0L)).toInstant()))));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unscheduleJob(JOB_ID);
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    final class JmxLoggerJobRunner
    implements JobRunner {
        JmxLoggerJobRunner() {
        }

        @Nonnull
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
            try {
                JmxLoggerScheduler.this.jmxLoggerService.logJMXInstruments();
            }
            catch (IOException e) {
                return JobRunnerResponse.failed((Throwable)e);
            }
            return JobRunnerResponse.success();
        }
    }
}

