/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd;

import com.atlassian.plugin.util.ClassLoaderUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JmxLoggerService {
    private final Clock clock;
    private final Logger log = LoggerFactory.getLogger(JmxLoggerService.class);
    private final Logger jmxPerformanceLogger = LoggerFactory.getLogger((String)"jmx-performance-data-logger");
    private final MBeanServer mBeanServer;
    private final ObjectMapper objectMapper;
    private InstrumentQuery[] queries = new InstrumentQuery[0];

    public JmxLoggerService(Clock clock) {
        this.clock = clock;
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.objectMapper = new ObjectMapper();
        this.queries = this.getInstrumentQueries();
    }

    void logJMXInstruments() throws IOException {
        this.initInstrumentQueries();
        for (InstrumentQuery instrumentQuery : this.queries) {
            this.log.debug("Running instrument query: {}", (Object)instrumentQuery.label);
            List result = instrumentQuery.objectNames.stream().map(o -> this.createInstrumentQueryResults((ObjectName)o, instrumentQuery)).filter(Objects::nonNull).collect(Collectors.toList());
            if (result.isEmpty()) continue;
            this.jmxPerformanceLogger.info("{}: {}", (Object)instrumentQuery.label, (Object)this.objectMapper.writeValueAsString(result));
        }
    }

    private InstrumentQueryResults createInstrumentQueryResults(ObjectName objectName, InstrumentQuery instrumentQuery) {
        try {
            AttributeList attributeList = new AttributeList(this.mBeanServer.getAttributes(objectName, instrumentQuery.attributes));
            if (!attributeList.isEmpty()) {
                return new InstrumentQueryResults(attributeList, instrumentQuery.label, objectName.getCanonicalName(), String.valueOf(Instant.now(this.clock).getEpochSecond()));
            }
        }
        catch (JMException e) {
            if (objectName != null) {
                this.log.error("Cannot query ObjectName with name {}}", (Object)objectName.getCanonicalName(), (Object)e);
            }
            this.log.error("Cannot query null ObjectName", (Throwable)e);
        }
        return null;
    }

    private InstrumentQuery[] getInstrumentQueries() {
        String fileName = "perflogInstruments.json";
        try {
            return (InstrumentQuery[])this.objectMapper.readValue(ClassLoaderUtils.getResourceAsStream((String)"perflogInstruments.json", this.getClass()), InstrumentQuery[].class);
        }
        catch (IOException e) {
            this.log.warn(String.format("Couldn't read %s, JMX instruments will not be logged", "perflogInstruments.json"), (Throwable)e);
            return new InstrumentQuery[0];
        }
    }

    private void initInstrumentQueries() {
        for (InstrumentQuery query : this.queries) {
            this.log.debug("Initializing query for label: {}", (Object)query.label);
            try {
                query.init();
            }
            catch (MalformedObjectNameException e) {
                this.log.warn("Malformed object name: {}", (Object)query.name);
                throw new RuntimeException(String.format("Could not initialize %s, because of malformed object", query), e);
            }
        }
    }

    private static class InstrumentQuery {
        private final String[] attributes;
        private final String label;
        private final String name;
        @JsonIgnore
        private Set<ObjectName> objectNames;

        InstrumentQuery(@JsonProperty(value="attributes") String[] attributes, @JsonProperty(value="label") String label, @JsonProperty(value="name") String name) {
            this.attributes = attributes;
            this.label = label;
            this.name = name;
        }

        void init() throws MalformedObjectNameException {
            this.objectNames = ManagementFactory.getPlatformMBeanServer().queryNames(new ObjectName(this.name), null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InstrumentQuery)) {
                return false;
            }
            InstrumentQuery query = (InstrumentQuery)o;
            return Objects.equals(this.label, query.label) && Objects.equals(this.name, query.name) && Arrays.equals(this.attributes, query.attributes);
        }

        public int hashCode() {
            int result = Objects.hash(this.label, this.name);
            result = 31 * result + Arrays.hashCode(this.attributes);
            return result;
        }

        public String toString() {
            return "InstrumentQuery{attributes=" + Arrays.toString(this.attributes) + ", label='" + this.label + "', name='" + this.name + "', objectNames=" + String.valueOf(this.objectNames) + "}";
        }
    }

    private record InstrumentQueryResults(AttributeList attributes, String label, String objectName, String timestamp) {
    }
}

