/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.http;

import com.atlassian.bitbucket.internal.ipd.http.HttpMonitoringService;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.ServletRequest;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultHttpMonitoringService
implements HttpMonitoringService {
    private final Clock clock;
    private final AtomicReference<Instant> lastClean;
    private final ConcurrentLinkedQueue<Instant> requestTimestampQueue;
    private final Duration requestTTL;

    public DefaultHttpMonitoringService(Clock clock) {
        this(clock, new AtomicReference<Instant>(clock.instant()), new ConcurrentLinkedQueue<Instant>(), Duration.ofMinutes(1L));
    }

    @VisibleForTesting
    DefaultHttpMonitoringService(Clock clock, AtomicReference<Instant> lastClean, ConcurrentLinkedQueue<Instant> requestTimestampQueue, Duration requestTTL) {
        this.clock = clock;
        this.requestTTL = requestTTL;
        this.lastClean = lastClean;
        this.requestTimestampQueue = requestTimestampQueue;
    }

    @Override
    public long numberOfRecentRequests(Long milliseconds) {
        return this.requestTimestampQueue.stream().filter(instant -> instant.plus((long)milliseconds, ChronoUnit.MILLIS).isAfter(this.clock.instant())).count();
    }

    @Override
    public void registerHttpRequest(ServletRequest servletRequest) {
        this.countRequest();
    }

    private void countRequest() {
        Instant currentTime = this.clock.instant();
        this.requestTimestampQueue.add(currentTime);
        if (this.shouldClean(currentTime)) {
            this.cleanQueue(currentTime);
        }
    }

    private void cleanQueue(Instant instant) {
        this.requestTimestampQueue.removeIf(time -> Duration.between(instant, time.plus(this.requestTTL)).isNegative());
        this.lastClean.set(instant);
    }

    private boolean shouldClean(Instant instant) {
        return this.lastClean.get().plus(this.requestTTL).isBefore(instant);
    }
}

