/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.http;

import com.atlassian.bitbucket.internal.ipd.http.IpdHttpSessionService;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueAndStatsMeterWrapper;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.Objects;

public class HttpActiveSessionsJob
implements IpdJob {
    private final ValueAndStatsMeterWrapper activeSessionsMetric;
    private final IpdHttpSessionService service;

    public HttpActiveSessionsJob(IpdJobRegistry ipdJobRegistry, IpdHttpSessionService sessionService, IpdRegistry ipdRegistry) {
        this.service = Objects.requireNonNull(sessionService);
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "http.connection.sessions.active");
        this.activeSessionsMetric = Objects.requireNonNull(ipdRegistry).valueAndStats("http.connection.sessions.active", new MeterTag[0]);
    }

    public void runJob() {
        long activeSessions = this.service.activeSessionsCount();
        this.activeSessionsMetric.update(Long.valueOf(activeSessions));
    }
}

