/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.http;

import com.atlassian.bitbucket.internal.ipd.http.DefaultHttpConnectionPoolService;
import com.atlassian.bitbucket.internal.ipd.http.HttpConnectionPoolMetric;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueMeter;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.Objects;

public class HttpConnectionPoolIpdJob
implements IpdJob {
    private final DefaultHttpConnectionPoolService defaultHttpConnectionPoolService;
    private final ValueMeter numActiveMetric;
    private final ValueMeter numIdleMetric;
    private final ValueMeter numMaxMetric;

    public HttpConnectionPoolIpdJob(IpdJobRegistry ipdJobRegistry, DefaultHttpConnectionPoolService defaultHttpConnectionPoolService, IpdRegistry ipdRegistry) {
        this.defaultHttpConnectionPoolService = Objects.requireNonNull(defaultHttpConnectionPoolService);
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "http.connection.pool");
        this.numIdleMetric = ipdRegistry.value("http.connection.pool.numIdle", new MeterTag[0]);
        this.numMaxMetric = ipdRegistry.value("http.connection.pool.numMax", new MeterTag[0]);
        this.numActiveMetric = ipdRegistry.value("http.connection.pool.numActive", new MeterTag[0]);
    }

    public void runJob() {
        HttpConnectionPoolMetric metric = this.defaultHttpConnectionPoolService.getHttpPoolSizeValue();
        this.numIdleMetric.update((long)metric.getNumIdle());
        this.numActiveMetric.update((long)metric.getNumActive());
        this.numMaxMetric.update((long)metric.getNumMax());
    }
}

