/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.http;

import com.atlassian.bitbucket.internal.ipd.http.IpdHttpSessionService;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueMeter;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;

public class HttpRecentSessionsJob
implements IpdJob {
    private static final Duration RECENTLY_ACTIVE_SESSIONS = Duration.ofHours(1L);
    private final IpdHttpSessionService service;
    private final ValueMeter recentSessionsMetric;

    public HttpRecentSessionsJob(IpdJobRegistry ipdJobRegistry, @Nonnull IpdHttpSessionService sessionService, IpdRegistry ipdRegistry) {
        this.service = Objects.requireNonNull(sessionService);
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "http.connection.sessions.recent");
        this.recentSessionsMetric = Objects.requireNonNull(ipdRegistry).value("http.connection.sessions.recent", new MeterTag[0]);
    }

    public void runJob() {
        long recentSessionsCount = this.service.recentSessionsCount(RECENTLY_ACTIVE_SESSIONS.toMillis());
        this.recentSessionsMetric.update(recentSessionsCount);
    }
}

