/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.http;

import com.atlassian.bitbucket.internal.ipd.http.HttpMonitoringService;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueAndStatsMeterWrapper;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class HttpRequestsJob
implements IpdJob {
    private static final long METRIC_PERIOD = TimeUnit.MINUTES.toMillis(1L);
    private final HttpMonitoringService httpMonitoringService;
    private final ValueAndStatsMeterWrapper requestsPerMinuteMetric;

    public HttpRequestsJob(IpdJobRegistry ipdJobRegistry, HttpMonitoringService httpMonitoringService, IpdRegistry ipdRegistry) {
        this.httpMonitoringService = Objects.requireNonNull(httpMonitoringService);
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "http.requests");
        this.requestsPerMinuteMetric = Objects.requireNonNull(ipdRegistry).valueAndStats("http.requests", new MeterTag[0]);
    }

    public void runJob() {
        long requestsPerMinute = this.httpMonitoringService.numberOfRecentRequests(METRIC_PERIOD);
        this.requestsPerMinuteMetric.update(Long.valueOf(requestsPerMinute));
    }
}

