/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.http;

import com.atlassian.bitbucket.internal.ipd.http.IpdSessionListener;
import java.time.Clock;

public class IpdHttpSessionService {
    private final Clock clock;
    private final IpdSessionListener ipdSessionListener;

    public IpdHttpSessionService(Clock clock, IpdSessionListener ipdSessionListener) {
        this.clock = clock;
        this.ipdSessionListener = ipdSessionListener;
    }

    public long activeSessionsCount() {
        return this.ipdSessionListener.getLastAccessedTimeValues().size();
    }

    public long recentSessionsCount(Long milliseconds) {
        long minimalAcceptedTimestamp = this.clock.millis() - milliseconds;
        return this.ipdSessionListener.getLastAccessedTimeValues().stream().filter(lastAccessedTimestamp -> lastAccessedTimestamp >= minimalAcceptedTimestamp).count();
    }
}

