/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.http;

import com.google.common.collect.ImmutableList;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IpdSessionListener
implements HttpSessionListener {
    private final Map<String, Long> lastAccessedTimeMap = new ConcurrentHashMap<String, Long>();

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        String id = httpSessionEvent.getSession().getId();
        long lastAccessedTime = httpSessionEvent.getSession().getLastAccessedTime();
        this.lastAccessedTimeMap.put(id, lastAccessedTime);
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        this.lastAccessedTimeMap.remove(httpSessionEvent.getSession().getId());
    }

    public List<Long> getLastAccessedTimeValues() {
        return ImmutableList.copyOf(this.lastAccessedTimeMap.values());
    }
}

