/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.ssh;

import com.atlassian.bitbucket.internal.ipd.ssh.SshIpdMetric;
import com.atlassian.bitbucket.internal.ipd.ssh.SshMetricsService;
import com.atlassian.bitbucket.internal.ipd.ssh.SshSessionMetrics;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.CounterMeter;
import com.atlassian.diagnostics.ipd.api.meters.ValueAndStatsMeterWrapper;
import com.atlassian.diagnostics.ipd.api.meters.ValueMeter;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;

public class SshMetricsIpdJob
implements IpdJob {
    private final SshMetricsService sshMetricsService;
    private final ValueAndStatsMeterWrapper activeSessionsMetric;
    private final ValueAndStatsMeterWrapper createdSessionsMetric;
    private final ValueMeter closedSessionsMetric;
    private final CounterMeter sessionErrorsMetric;
    private final ValueMeter sessionsDisconnectedLimitMetric;
    private final Map<String, LongAdder> previousMeasurements = new HashMap<String, LongAdder>();

    public SshMetricsIpdJob(IpdJobRegistry ipdJobRegistry, SshMetricsService sshMetricsService, IpdRegistry ipdRegistry) {
        this.sshMetricsService = Objects.requireNonNull(sshMetricsService);
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "ssh.sessions");
        this.activeSessionsMetric = ipdRegistry.valueAndStats("ssh.sessions.active", new MeterTag[0]);
        this.createdSessionsMetric = ipdRegistry.valueAndStats("ssh.sessions.created", new MeterTag[0]);
        this.closedSessionsMetric = ipdRegistry.value("ssh.sessions.closed", new MeterTag[0]);
        this.sessionErrorsMetric = ipdRegistry.counter("ssh.sessions.error", new MeterTag[0]);
        this.sessionsDisconnectedLimitMetric = ipdRegistry.value("ssh.sessions.disconnected.limit", new MeterTag[0]);
    }

    public void runJob() {
        SshSessionMetrics metrics = this.sshMetricsService.getSshSessionMetrics();
        this.activeSessionsMetric.update(Long.valueOf(metrics.getSessionsActive().getValue()));
        this.createdSessionsMetric.update(Long.valueOf(this.countValuePerInterval(metrics.getSessionsCreated())));
        this.closedSessionsMetric.update(this.countValuePerInterval(metrics.getSessionsClosed()));
        this.sessionErrorsMetric.increment(this.countValuePerInterval(metrics.getSessionsException()));
        this.sessionsDisconnectedLimitMetric.update(this.countValuePerInterval(metrics.getSessionsDisconnectedLimit()));
    }

    private long countValuePerInterval(SshIpdMetric metric) {
        String metricName = metric.getName();
        LongAdder previousMeasurement = this.previousMeasurements.computeIfAbsent(metricName, name -> new LongAdder());
        long currentMeasurement = metric.getValue() - previousMeasurement.longValue();
        previousMeasurement.add(currentMeasurement);
        return currentMeasurement;
    }
}

