/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.ssh;

import com.atlassian.bitbucket.internal.ipd.ssh.SshSessionMetrics;
import com.google.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshMetricsService {
    @VisibleForTesting
    static final String ACTIVE_SESSION_COUNT = "ActiveSessionCount";
    @VisibleForTesting
    static final String SESSION_CLOSED_COUNT = "SessionClosedCount";
    @VisibleForTesting
    static final String SESSION_CREATED_COUNT = "SessionCreatedCount";
    @VisibleForTesting
    static final String SESSION_DISCONNECTED_LIMIT_COUNT = "SessionDisconnectedLimitCount";
    @VisibleForTesting
    static final String SESSION_EXCEPTION_COUNT = "SessionExceptionCount";
    @VisibleForTesting
    static final String SSH_MBEAN_NAME = "com.atlassian.bitbucket:name=SshSessions";
    private static final Logger log = LoggerFactory.getLogger(SshMetricsService.class);

    public SshSessionMetrics getSshSessionMetrics() {
        MBeanServer platformMBeanServer = this.getPlatformMBeanServer();
        long numActive = 0L;
        long numCreated = 0L;
        long numClosed = 0L;
        long numException = 0L;
        long numDisconnectedLimit = 0L;
        try {
            ObjectName sshMBeanName = new ObjectName(SSH_MBEAN_NAME);
            if (platformMBeanServer.isRegistered(sshMBeanName)) {
                numActive = (Long)platformMBeanServer.getAttribute(sshMBeanName, ACTIVE_SESSION_COUNT);
                numCreated = (Long)platformMBeanServer.getAttribute(sshMBeanName, SESSION_CREATED_COUNT);
                numClosed = (Long)platformMBeanServer.getAttribute(sshMBeanName, SESSION_CLOSED_COUNT);
                numException = (Long)platformMBeanServer.getAttribute(sshMBeanName, SESSION_EXCEPTION_COUNT);
                numDisconnectedLimit = (Long)platformMBeanServer.getAttribute(sshMBeanName, SESSION_DISCONNECTED_LIMIT_COUNT);
            }
        }
        catch (MalformedObjectNameException ex) {
            log.error("{}: Exception occurred while constructing MBean, metrics will not be reported", (Object)SSH_MBEAN_NAME, (Object)ex);
        }
        catch (Exception ex) {
            log.warn("Unable to read attribute", (Throwable)ex);
        }
        return new SshSessionMetrics(numActive, numCreated, numClosed, numException, numDisconnectedLimit);
    }

    @VisibleForTesting
    MBeanServer getPlatformMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }
}

