/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.ssh;

import com.atlassian.bitbucket.internal.ipd.ssh.SshIpdMetric;

public class SshSessionMetrics {
    static final String SSH_SESSIONS_ACTIVE_METRIC_NAME = "ssh.sessions.active";
    static final String SSH_SESSIONS_CREATED_METRIC_NAME = "ssh.sessions.created";
    static final String SSH_SESSIONS_CLOSED_METRIC_NAME = "ssh.sessions.closed";
    static final String SSH_SESSIONS_ERROR_METRIC_NAME = "ssh.sessions.error";
    static final String SSH_SESSIONS_DISCONNECTED_LIMIT_METRIC_NAME = "ssh.sessions.disconnected.limit";
    private final SshIpdMetric sessionsActive;
    private final SshIpdMetric sessionsCreated;
    private final SshIpdMetric sessionsClosed;
    private final SshIpdMetric sessionsException;
    private final SshIpdMetric sessionsDisconnectedLimit;

    public SshSessionMetrics(long sessionsActiveCount, long sessionsCreatedCount, long sessionsClosedCount, long sessionsExceptionCount, long sessionsDisconnectedLimitCount) {
        this.sessionsActive = new SshIpdMetric(SSH_SESSIONS_ACTIVE_METRIC_NAME, sessionsActiveCount);
        this.sessionsCreated = new SshIpdMetric(SSH_SESSIONS_CLOSED_METRIC_NAME, sessionsCreatedCount);
        this.sessionsClosed = new SshIpdMetric(SSH_SESSIONS_CREATED_METRIC_NAME, sessionsClosedCount);
        this.sessionsException = new SshIpdMetric(SSH_SESSIONS_ERROR_METRIC_NAME, sessionsExceptionCount);
        this.sessionsDisconnectedLimit = new SshIpdMetric(SSH_SESSIONS_DISCONNECTED_LIMIT_METRIC_NAME, sessionsDisconnectedLimitCount);
    }

    public SshIpdMetric getSessionsActive() {
        return this.sessionsActive;
    }

    public SshIpdMetric getSessionsCreated() {
        return this.sessionsCreated;
    }

    public SshIpdMetric getSessionsClosed() {
        return this.sessionsClosed;
    }

    public SshIpdMetric getSessionsException() {
        return this.sessionsException;
    }

    public SshIpdMetric getSessionsDisconnectedLimit() {
        return this.sessionsDisconnectedLimit;
    }
}

