/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.storage;

import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesHelper {
    private static final Logger log = LoggerFactory.getLogger(FilesHelper.class);

    public long getDirectorySize(@Nonnull Path path) {
        return FileUtils.sizeOfDirectory((File)path.toFile());
    }

    public Optional<FileStore> getFileStore(@Nonnull Path path) {
        try {
            return Optional.of(Files.getFileStore(path));
        }
        catch (IOException e) {
            log.debug("Couldn't get FileStore: {}", (Object)path, (Object)e);
            return Optional.empty();
        }
    }
}

