/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.storage.local;

import com.atlassian.bitbucket.internal.ipd.storage.local.LocalStorageSpaceMetrics;
import com.atlassian.bitbucket.internal.ipd.storage.local.LocalStorageSpaceService;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStorageSpaceIpdJob
implements IpdJob {
    private static final Logger log = LoggerFactory.getLogger(LocalStorageSpaceIpdJob.class);
    private static final String METRIC_PREFIX = "storage.space.local";
    private static final String METRIC_CACHES = "storage.space.local.caches";
    private static final String METRIC_FREE = "storage.space.local.free";
    private static final String METRIC_LOGS = "storage.space.local.logs";
    private static final String METRIC_TMP = "storage.space.local.tmp";
    private static final String METRIC_USED = "storage.space.local.used";
    private static final int MINIMUM_REFRESH_INTERVAL = 10;
    private final IpdRegistry ipdRegistry;
    private final LocalStorageSpaceService localStorageSpaceService;
    private final int refreshInterval;
    private Instant lastCallTime;

    public LocalStorageSpaceIpdJob(IpdJobRegistry ipdJobRegistry, LocalStorageSpaceService localStorageSpaceService, int customRefreshInterval, IpdRegistry ipdRegistry) {
        this.localStorageSpaceService = Objects.requireNonNull(localStorageSpaceService);
        this.ipdRegistry = Objects.requireNonNull(ipdRegistry);
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, METRIC_PREFIX);
        if (customRefreshInterval < 10) {
            this.refreshInterval = 10;
            log.info("The refresh interval for Local Storage Space IPD metric cannot be less than {} and therefore the default minimum value will be used", (Object)10);
        } else {
            this.refreshInterval = customRefreshInterval;
        }
    }

    public void runJob() {
        if (this.lastCallTime != null && Instant.now().minus(this.refreshInterval, ChronoUnit.MINUTES).isBefore(this.lastCallTime)) {
            return;
        }
        this.lastCallTime = Instant.now();
        LocalStorageSpaceMetrics metrics = this.localStorageSpaceService.getMetrics();
        if (metrics.getFree() != null) {
            this.ipdRegistry.setValue(METRIC_FREE, metrics.getFree().longValue(), new MeterTag[0]);
        }
        if (metrics.getUsed() != null) {
            this.ipdRegistry.setValue(METRIC_USED, metrics.getUsed().longValue(), new MeterTag[0]);
        }
        this.ipdRegistry.setValue(METRIC_CACHES, metrics.getCaches(), new MeterTag[0]);
        this.ipdRegistry.setValue(METRIC_LOGS, metrics.getLogs(), new MeterTag[0]);
        this.ipdRegistry.setValue(METRIC_TMP, metrics.getTmp(), new MeterTag[0]);
    }
}

