/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.storage.local;

import com.atlassian.bitbucket.internal.ipd.storage.FilesHelper;
import com.atlassian.bitbucket.internal.ipd.storage.local.LocalStorageSpaceMetrics;
import com.atlassian.stash.internal.HomeLayout;
import java.io.IOException;
import java.nio.file.FileStore;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStorageSpaceService {
    private static final Logger log = LoggerFactory.getLogger(LocalStorageSpaceService.class);
    private final FilesHelper filesHelper;
    private final HomeLayout homeLayout;

    public LocalStorageSpaceService(FilesHelper filesHelper, HomeLayout homeLayout) {
        this.filesHelper = filesHelper;
        this.homeLayout = homeLayout;
    }

    LocalStorageSpaceMetrics getMetrics() {
        Long free = null;
        Long used = null;
        Optional<FileStore> fileStore = this.filesHelper.getFileStore(this.homeLayout.getSharedHomeDir());
        if (fileStore.isPresent()) {
            try {
                long totalSpace = fileStore.get().getTotalSpace();
                free = fileStore.get().getUsableSpace();
                used = totalSpace - free;
            }
            catch (IOException e) {
                log.debug("Failed to fetch storage space information. IPD metrics won't contain complete local storage data.", (Throwable)e);
            }
        }
        long caches = this.filesHelper.getDirectorySize(this.homeLayout.getCacheDir());
        long logs = this.filesHelper.getDirectorySize(this.homeLayout.getLogDir());
        long tmp = this.filesHelper.getDirectorySize(this.homeLayout.getTempDir());
        return new LocalStorageSpaceMetrics(free, used, caches, logs, tmp);
    }
}

