/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.tickets.command;

import com.atlassian.bitbucket.internal.ipd.tickets.command.CommandTicketsMetrics;
import com.atlassian.bitbucket.internal.ipd.tickets.command.CommandTicketsService;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueAndStatsMeterWrapper;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.Objects;

public class CommandTicketsIpdJob
implements IpdJob {
    private final ValueAndStatsMeterWrapper availableCommandTicketsMetric;
    private final CommandTicketsService commandTicketsService;
    private final ValueAndStatsMeterWrapper usedCommandTicketsMetric;

    public CommandTicketsIpdJob(IpdJobRegistry ipdJobRegistry, CommandTicketsService commandTicketsService, IpdRegistry ipdRegistry) {
        this.commandTicketsService = Objects.requireNonNull(commandTicketsService);
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "tickets.command");
        this.usedCommandTicketsMetric = ipdRegistry.valueAndStats("tickets.command.used", new MeterTag[0]);
        this.availableCommandTicketsMetric = ipdRegistry.valueAndStats("tickets.command.available", new MeterTag[0]);
    }

    public void runJob() {
        this.commandTicketsService.getCommandTicketsMetrics().ifPresent(this::updateIpdMeasurements);
    }

    private void updateIpdMeasurements(CommandTicketsMetrics commandTicketsMetrics) {
        this.usedCommandTicketsMetric.update(Long.valueOf(commandTicketsMetrics.getNumUsed()));
        this.availableCommandTicketsMetric.update(Long.valueOf(commandTicketsMetrics.getNumAvailable()));
    }
}

