/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.tickets.command;

import com.atlassian.bitbucket.internal.ipd.tickets.command.CommandTicketsMetrics;
import java.lang.management.ManagementFactory;
import java.util.Optional;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandTicketsService {
    public static final String SOURCE_MBEAN = "*:name=CommandTickets";
    private static final Logger log = LoggerFactory.getLogger(CommandTicketsService.class);

    Optional<CommandTicketsMetrics> getCommandTicketsMetrics() {
        MBeanServer platformMBeanServer = this.getPlatformMBeanServer();
        return this.findCommandTicketsMBeanName(platformMBeanServer).flatMap(this::readMetricValues);
    }

    private Optional<CommandTicketsMetrics> readMetricValues(ObjectName objectName) {
        MBeanServer platformMBeanServer = this.getPlatformMBeanServer();
        try {
            int used = (Integer)platformMBeanServer.getAttribute(objectName, "Used");
            int active = (Integer)platformMBeanServer.getAttribute(objectName, "Available");
            return Optional.of(new CommandTicketsMetrics(used, active));
        }
        catch (Exception ex) {
            log.warn("Unable to read attribute", (Throwable)ex);
            return Optional.empty();
        }
    }

    private Optional<ObjectName> findCommandTicketsMBeanName(MBeanServer platformMBeanServer) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(SOURCE_MBEAN);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
        return platformMBeanServer.queryNames(objectName, null).stream().findFirst();
    }

    public MBeanServer getPlatformMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }
}

