/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.tickets.hosting;

import com.atlassian.bitbucket.internal.ipd.tickets.hosting.HostingTicketsMetrics;
import com.atlassian.bitbucket.internal.ipd.tickets.hosting.HostingTicketsService;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueAndStatsMeterWrapper;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.Objects;

public class HostingTicketsIpdJob
implements IpdJob {
    private final ValueAndStatsMeterWrapper availableHostingTicketsMetric;
    private final HostingTicketsService hostingTicketsService;
    private final ValueAndStatsMeterWrapper usedHostingTicketsMetric;

    public HostingTicketsIpdJob(IpdJobRegistry ipdJobRegistry, HostingTicketsService hostingTicketsService, IpdRegistry ipdRegistry) {
        this.hostingTicketsService = Objects.requireNonNull(hostingTicketsService);
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "tickets.hosting");
        this.usedHostingTicketsMetric = ipdRegistry.valueAndStats("tickets.hosting.used", new MeterTag[0]);
        this.availableHostingTicketsMetric = ipdRegistry.valueAndStats("tickets.hosting.available", new MeterTag[0]);
    }

    public void runJob() {
        this.hostingTicketsService.getHostingTicketsMetrics().ifPresent(this::updateIpdMeasurements);
    }

    private void updateIpdMeasurements(HostingTicketsMetrics hostingTicketsMetrics) {
        this.usedHostingTicketsMetric.update(Long.valueOf(hostingTicketsMetrics.getNumUsed()));
        this.availableHostingTicketsMetric.update(Long.valueOf(hostingTicketsMetrics.getNumAvailable()));
    }
}

