/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ipd.tickets.hosting;

import com.atlassian.bitbucket.internal.ipd.tickets.hosting.HostingTicketsMetrics;
import java.lang.management.ManagementFactory;
import java.util.Optional;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostingTicketsService {
    static final String SOURCE_MBEAN = "*:name=HostingTickets";
    private static final Logger log = LoggerFactory.getLogger(HostingTicketsService.class);

    Optional<HostingTicketsMetrics> getHostingTicketsMetrics() {
        MBeanServer platformMBeanServer = this.getPlatformMBeanServer();
        return this.findHostingTicketsMBeanName(platformMBeanServer).flatMap(this::readMetricValues);
    }

    private Optional<HostingTicketsMetrics> readMetricValues(ObjectName objectName) {
        MBeanServer platformMBeanServer = this.getPlatformMBeanServer();
        try {
            int used = (Integer)platformMBeanServer.getAttribute(objectName, "Used");
            int available = (Integer)platformMBeanServer.getAttribute(objectName, "Available");
            return Optional.of(new HostingTicketsMetrics(used, available));
        }
        catch (Exception ex) {
            log.warn("Unable to read attribute", (Throwable)ex);
            return Optional.empty();
        }
    }

    private Optional<ObjectName> findHostingTicketsMBeanName(MBeanServer platformMBeanServer) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(SOURCE_MBEAN);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
        return platformMBeanServer.queryNames(objectName, null).stream().findFirst();
    }

    MBeanServer getPlatformMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }
}

