/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.diagnostics.ipd.api.CachedIpdState;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.util.Objects;

public class BitbucketIpdState
extends CachedIpdState {
    public static final String IPD_DARK_FEATURE_DISABLED = "bitbucket.in.product.diagnostics.deny";
    public static final String IPD_DARK_FEATURE_WIP = "bitbucket.in.product.diagnostics.wip";
    public static final String IPD_EXTRA_LOGGING_DARK_FEATURE = "bitbucket.in.product.diagnostics.extended.logging";
    private final DarkFeatureManager darkFeatureManager;
    private final boolean isJmxEnabled;

    public BitbucketIpdState(boolean isJmxEnabled, DarkFeatureManager darkFeatureManager) {
        this.isJmxEnabled = isJmxEnabled;
        this.darkFeatureManager = Objects.requireNonNull(darkFeatureManager);
    }

    public boolean isExtraLoggingFeatureFlagEnabled() {
        return this.darkFeatureManager.isEnabledForAllUsers(IPD_EXTRA_LOGGING_DARK_FEATURE).orElse(false);
    }

    public boolean isIpdFeatureFlagEnabled() {
        return this.isJmxEnabled && this.darkFeatureManager.isEnabledForAllUsers(IPD_DARK_FEATURE_DISABLED).orElse(false) == false;
    }

    public boolean isWipIpdFeatureFlagEnabled() {
        return this.darkFeatureManager.isEnabledForAllUsers(IPD_DARK_FEATURE_WIP).orElse(false);
    }

    public void setIsIpdFeatureFlagEnabled(boolean enabled) {
        if (enabled) {
            this.darkFeatureManager.disableFeatureForAllUsers(IPD_DARK_FEATURE_DISABLED);
        } else {
            this.darkFeatureManager.enableFeatureForAllUsers(IPD_DARK_FEATURE_DISABLED);
        }
    }

    public void refreshState() {
        this.isIpdFeatureFlagEnabled.set(this.isIpdFeatureFlagEnabled());
        this.isWipIpdFeatureFlagEnabled.set(this.isWipIpdFeatureFlagEnabled());
        this.isIpdExtraLoggingEnabled.set(this.isExtraLoggingFeatureFlagEnabled());
    }
}

