/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.bitbucket.dmz.monitoring.DmzMonitoringSettingsService;
import com.atlassian.bitbucket.dmz.web.ServletEventListenerMediator;
import com.atlassian.bitbucket.internal.ipd.BitbucketIpdJobRunner;
import com.atlassian.bitbucket.internal.ipd.DefaultMonitoringSettingsService;
import com.atlassian.bitbucket.internal.ipd.IpdCollectorScheduler;
import com.atlassian.bitbucket.internal.ipd.IpdEmitterScheduler;
import com.atlassian.bitbucket.internal.ipd.JmxLoggerScheduler;
import com.atlassian.bitbucket.internal.ipd.JmxLoggerService;
import com.atlassian.bitbucket.internal.ipd.http.DefaultHttpConnectionPoolService;
import com.atlassian.bitbucket.internal.ipd.http.DefaultHttpMonitoringService;
import com.atlassian.bitbucket.internal.ipd.http.HttpActiveSessionsJob;
import com.atlassian.bitbucket.internal.ipd.http.HttpConnectionPoolIpdJob;
import com.atlassian.bitbucket.internal.ipd.http.HttpMonitoringService;
import com.atlassian.bitbucket.internal.ipd.http.HttpRecentSessionsJob;
import com.atlassian.bitbucket.internal.ipd.http.HttpRequestsJob;
import com.atlassian.bitbucket.internal.ipd.http.IpdHttpSessionService;
import com.atlassian.bitbucket.internal.ipd.http.IpdSessionListener;
import com.atlassian.bitbucket.internal.ipd.ssh.SshMetricsIpdJob;
import com.atlassian.bitbucket.internal.ipd.ssh.SshMetricsService;
import com.atlassian.bitbucket.internal.ipd.storage.FilesHelper;
import com.atlassian.bitbucket.internal.ipd.storage.local.LocalStorageSpaceIpdJob;
import com.atlassian.bitbucket.internal.ipd.storage.local.LocalStorageSpaceService;
import com.atlassian.bitbucket.internal.ipd.tickets.command.CommandTicketsIpdJob;
import com.atlassian.bitbucket.internal.ipd.tickets.command.CommandTicketsService;
import com.atlassian.bitbucket.internal.ipd.tickets.hosting.HostingTicketsIpdJob;
import com.atlassian.bitbucket.internal.ipd.tickets.hosting.HostingTicketsService;
import com.atlassian.diagnostics.internal.ipd.DefaultIpdJobRunner;
import com.atlassian.diagnostics.internal.ipd.DefaultLoggingService;
import com.atlassian.diagnostics.internal.ipd.DefaultPluginIpdFactory;
import com.atlassian.diagnostics.internal.ipd.IpdMeterRegistry;
import com.atlassian.diagnostics.internal.ipd.IpdRegistryLogger;
import com.atlassian.diagnostics.internal.ipd.IpdUtils;
import com.atlassian.diagnostics.ipd.api.CachedIpdState;
import com.atlassian.diagnostics.ipd.api.IpdLoggingService;
import com.atlassian.diagnostics.ipd.api.MeterConfigurations;
import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRunner;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.atlassian.diagnostics.ipd.api.registry.PluginIpdFactory;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.stash.internal.BitbucketIpdState;
import com.atlassian.stash.internal.HomeLayout;
import jakarta.servlet.http.HttpSessionListener;
import java.time.Clock;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"com.atlassian.bitbucket.internal.ipd"})
public class IpdWiring {
    @Bean
    public MeterConfigurations getMeterConfigurations(IpdLoggingService loggingService, CachedIpdState cachedIpdState) {
        return MeterConfigurations.create(b -> b.setObjectNameConstructor(name -> IpdUtils.constructObjectName((String)"com.atlassian.bitbucket", (MeterKey)name)).setUpdateListener(arg_0 -> ((IpdLoggingService)loggingService).logMetric(arg_0)).addEnabledCheck(meter -> cachedIpdState.isIpdEnabled()).addEnabledCheck(meter -> !meter.isWorkInProgress() || cachedIpdState.isWipIpdEnabled()));
    }

    @Bean
    public IpdMeterRegistry getIpdMeterRegistry(MeterConfigurations meterConfigurations) {
        return new IpdMeterRegistry(meterConfigurations);
    }

    @Bean
    public BitbucketIpdState getBitbucketIpdState(@Value(value="${jmx.enabled:true}") boolean isJmxEnabled, DarkFeatureManager darkFeatureManager) {
        return new BitbucketIpdState(isJmxEnabled, darkFeatureManager);
    }

    @Bean
    public IpdLoggingService getLoggingService(CachedIpdState cachedIpdState) {
        return new DefaultLoggingService(cachedIpdState);
    }

    @Bean
    @AvailableToPlugins(value=PluginIpdFactory.class)
    public PluginIpdFactory getPluginIpdFactory(IpdMeterRegistry ipdMeterRegistry, IpdJobRegistry ipdJobRegistry) {
        return new DefaultPluginIpdFactory(ipdMeterRegistry, ipdJobRegistry);
    }

    @Bean(name={"monitoringSettingsService"})
    @AvailableToPlugins(value=DmzMonitoringSettingsService.class)
    public DmzMonitoringSettingsService getMonitoringSettingsService(BitbucketIpdState bitbucketIpdState, IpdRegistry ipdRegistry) {
        return new DefaultMonitoringSettingsService(bitbucketIpdState, ipdRegistry);
    }

    @Bean
    public DefaultIpdJobRunner getDefaultIpdJobRunner(CachedIpdState cachedIpdState) {
        return new BitbucketIpdJobRunner(cachedIpdState);
    }

    @Configuration
    @ComponentScan(value={"com.atlassian.bitbucket.internal.ipd"})
    @ConditionalOnProperty(name={"jmx.enabled"}, havingValue="true")
    public static class IpdWiringJmxCondition {
        @Bean
        public IpdCollectorScheduler getIpdCollectorScheduler(IpdRegistryLogger ipdRegistryLogger) {
            return new IpdCollectorScheduler(ipdRegistryLogger);
        }

        @Bean
        public IpdEmitterScheduler getIpdEmitterScheduler(IpdJobRunner ipdJobRunner, IpdRegistry ipdRegistry, CachedIpdState cachedIpdState) {
            return new IpdEmitterScheduler(ipdJobRunner, ipdRegistry, cachedIpdState);
        }

        @Bean
        public IpdRegistryLogger getIpdRegistryLogger(IpdRegistry ipdRegistry, IpdLoggingService loggingService) {
            return new IpdRegistryLogger(ipdRegistry, loggingService);
        }

        @Bean
        public DefaultHttpConnectionPoolService getDefaultHttpConnectionPoolService() {
            return new DefaultHttpConnectionPoolService();
        }

        @Bean
        public HttpConnectionPoolIpdJob getHttpConnectionPoolIpdJob(IpdJobRegistry jobRegistry, IpdRegistry ipdRegistry) {
            return new HttpConnectionPoolIpdJob(jobRegistry, this.getDefaultHttpConnectionPoolService(), ipdRegistry);
        }

        @Bean
        public SshMetricsService getSshMetricsService() {
            return new SshMetricsService();
        }

        @Bean
        public SshMetricsIpdJob getSshMetricsIpdJob(IpdJobRegistry jobRegistry, SshMetricsService sshMetricsService, IpdRegistry ipdRegistry) {
            return new SshMetricsIpdJob(jobRegistry, sshMetricsService, ipdRegistry);
        }

        @Bean
        @ConditionalOnProperty(name={"mesh.enabled"}, havingValue="false")
        public CommandTicketsService getCommandTicketsService() {
            return new CommandTicketsService();
        }

        @Bean
        @ConditionalOnProperty(name={"mesh.enabled"}, havingValue="false")
        public CommandTicketsIpdJob getCommandTicketsIpdJob(IpdJobRegistry jobRegistry, IpdRegistry ipdRegistry) {
            return new CommandTicketsIpdJob(jobRegistry, this.getCommandTicketsService(), ipdRegistry);
        }

        @Bean
        @ConditionalOnProperty(name={"mesh.enabled"}, havingValue="false")
        public HostingTicketsService getHostingTicketsService() {
            return new HostingTicketsService();
        }

        @Bean
        @ConditionalOnProperty(name={"mesh.enabled"}, havingValue="false")
        public HostingTicketsIpdJob getHostingTicketsIpdJob(IpdJobRegistry jobRegistry, IpdRegistry ipdRegistry) {
            return new HostingTicketsIpdJob(jobRegistry, this.getHostingTicketsService(), ipdRegistry);
        }

        @Bean
        public HttpRequestsJob getHttpRequestsJob(IpdJobRegistry jobRegistry, HttpMonitoringService service, IpdRegistry ipdRegistry) {
            return new HttpRequestsJob(jobRegistry, service, ipdRegistry);
        }

        @Bean
        public HttpMonitoringService getHttpMonitoringService(Clock clock) {
            return new DefaultHttpMonitoringService(clock);
        }

        @Bean
        public IpdSessionListener sessionListener(ServletEventListenerMediator servletEventListenerMediator) {
            IpdSessionListener listener = new IpdSessionListener();
            servletEventListenerMediator.addListener((HttpSessionListener)listener);
            return listener;
        }

        @Bean
        public IpdHttpSessionService getSessionService(Clock clock, IpdSessionListener sessionListener) {
            return new IpdHttpSessionService(clock, sessionListener);
        }

        @Bean
        public HttpActiveSessionsJob getHttpActiveSessionsJob(IpdJobRegistry jobRegistry, IpdHttpSessionService ipdHttpSessionService, IpdRegistry ipdRegistry) {
            return new HttpActiveSessionsJob(jobRegistry, ipdHttpSessionService, ipdRegistry);
        }

        @Bean
        public HttpRecentSessionsJob getHttpRecentSessionsJob(IpdJobRegistry jobRegistry, IpdHttpSessionService ipdHttpSessionService, IpdRegistry ipdRegistry) {
            return new HttpRecentSessionsJob(jobRegistry, ipdHttpSessionService, ipdRegistry);
        }

        @Bean
        public FilesHelper getFilesHelper() {
            return new FilesHelper();
        }

        @Bean
        public LocalStorageSpaceService getLocalStorageSpaceService(FilesHelper filesHelper, HomeLayout homeLayout) {
            return new LocalStorageSpaceService(filesHelper, homeLayout);
        }

        @Bean
        public LocalStorageSpaceIpdJob getLocalStorageSpaceIpdJob(IpdJobRegistry jobRegistry, LocalStorageSpaceService localStorageSpaceService, @Value(value="${diagnostics.ipd.monitoring.poll.storage.interval.minutes:10}") int refreshInterval, IpdRegistry ipdRegistry) {
            return new LocalStorageSpaceIpdJob(jobRegistry, localStorageSpaceService, refreshInterval, ipdRegistry);
        }

        @Bean
        public JmxLoggerScheduler getJmxLoggerScheduler(Clock clock, JmxLoggerService jmxLoggerService) {
            return new JmxLoggerScheduler(clock, jmxLoggerService);
        }

        @Bean
        public JmxLoggerService getJmxLoggerService(Clock clock) {
            return new JmxLoggerService(clock);
        }
    }
}

