/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cache.impl;

import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.nio.ClassLoaderUtil;
import java.security.AccessController;

public final class JCacheDetector {
    private static final String JCACHE_CACHING_CLASSNAME = "javax.cache.Caching";
    private static final String[] JCACHE_ADDITIONAL_REQUIRED_CLASSES = new String[]{"javax.cache.integration.CacheLoaderException", "javax.cache.integration.CacheWriterException", "javax.cache.processor.EntryProcessorException", "javax.cache.configuration.CompleteConfiguration"};

    private JCacheDetector() {
    }

    public static boolean isJCacheAvailable(ClassLoader classLoader) {
        return JCacheDetector.isJCacheAvailable(classLoader, null);
    }

    static boolean isJCacheAvailable(ClassAvailabilityChecker classAvailabilityChecker) {
        return JCacheDetector.isJCacheAvailable(null, classAvailabilityChecker);
    }

    public static boolean isJCacheAvailable(ClassLoader classLoader, ILogger logger) {
        return JCacheDetector.isJCacheAvailable(logger, (String className) -> ClassLoaderUtil.isClassAvailable(classLoader, className));
    }

    static boolean isJCacheAvailable(ILogger logger, ClassAvailabilityChecker classAvailabilityChecker) {
        ClassLoader backupClassLoader = AccessController.doPrivileged(JCacheDetector.class::getClassLoader);
        return JCacheDetector.isJCacheAvailableInternal(logger, classAvailabilityChecker) || JCacheDetector.isJCacheAvailableInternal(logger, classAvailabilityChecker);
    }

    private static boolean isJCacheAvailableInternal(ILogger logger, ClassAvailabilityChecker classAvailabilityChecker) {
        if (!classAvailabilityChecker.isClassAvailable(JCACHE_CACHING_CLASSNAME)) {
            return false;
        }
        for (String className : JCACHE_ADDITIONAL_REQUIRED_CLASSES) {
            if (classAvailabilityChecker.isClassAvailable(className)) continue;
            if (logger != null) {
                logger.warning("An outdated version of JCache API was located in the classpath, please use newer versions of JCache API rather than 1.0.0-PFD or 0.x versions.");
            }
            return false;
        }
        return true;
    }

    @FunctionalInterface
    static interface ClassAvailabilityChecker {
        public boolean isClassAvailable(String var1);
    }
}

