/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cache.impl.operation;

import com.atlassian.nutcluster.cache.impl.operation.CacheOperation;
import com.atlassian.nutcluster.cache.impl.operation.CachePutAllBackupOperation;
import com.atlassian.nutcluster.cache.impl.record.CacheRecord;
import com.atlassian.nutcluster.instance.MemberImpl;
import com.atlassian.nutcluster.internal.cluster.Versions;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.BackupAwareOperation;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.impl.operationservice.TargetAware;
import com.atlassian.nutcluster.spi.merge.SplitBrainMergePolicy;
import com.atlassian.nutcluster.spi.merge.SplitBrainMergeTypes;
import com.atlassian.nutcluster.util.MapUtil;
import com.atlassian.nutcluster.version.Version;
import com.atlassian.nutcluster.wan.impl.CallerProvenance;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CacheMergeOperation
extends CacheOperation
implements BackupAwareOperation,
TargetAware {
    private List<SplitBrainMergeTypes.CacheMergeTypes> mergingEntries;
    private SplitBrainMergePolicy<Data, SplitBrainMergeTypes.CacheMergeTypes> mergePolicy;
    private transient boolean hasBackups;
    private transient Map<Data, CacheRecord> backupRecords;
    private transient Address target;

    public CacheMergeOperation() {
    }

    public CacheMergeOperation(String name, List<SplitBrainMergeTypes.CacheMergeTypes> mergingEntries, SplitBrainMergePolicy<Data, SplitBrainMergeTypes.CacheMergeTypes> mergePolicy) {
        super(name);
        this.mergingEntries = mergingEntries;
        this.mergePolicy = mergePolicy;
    }

    @Override
    protected void beforeRunInternal() {
        boolean bl = this.hasBackups = this.getSyncBackupCount() + this.getAsyncBackupCount() > 0;
        if (this.hasBackups) {
            this.backupRecords = MapUtil.createHashMap(this.mergingEntries.size());
        }
    }

    @Override
    public void run() {
        for (SplitBrainMergeTypes.CacheMergeTypes mergingEntry : this.mergingEntries) {
            this.merge(mergingEntry);
        }
    }

    private void merge(SplitBrainMergeTypes.CacheMergeTypes mergingEntry) {
        Data dataKey = (Data)mergingEntry.getKey();
        CacheRecord backupRecord = this.recordStore.merge(mergingEntry, this.mergePolicy, CallerProvenance.NOT_WAN);
        if (backupRecord != null) {
            this.backupRecords.put(dataKey, backupRecord);
        }
        if (this.recordStore.isWanReplicationEnabled()) {
            if (backupRecord != null) {
                this.publishWanUpdate(dataKey, backupRecord);
            } else {
                this.publishWanRemove(dataKey);
            }
        }
    }

    @Override
    public Object getResponse() {
        return !this.backupRecords.isEmpty();
    }

    @Override
    public boolean shouldBackup() {
        return this.hasBackups && !this.backupRecords.isEmpty();
    }

    @Override
    public Operation getBackupOperation() {
        return new CachePutAllBackupOperation(this.name, this.backupRecords);
    }

    @Override
    public void setTarget(Address address) {
        this.target = address;
    }

    @Override
    protected boolean requiresExplicitServiceName() {
        MemberImpl member = this.getNodeEngine().getClusterService().getMember(this.target);
        if (member == null) {
            return false;
        }
        Version memberVersion = member.getVersion().asVersion();
        return memberVersion.isLessThan(Versions.V3_11);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.mergingEntries.size());
        for (SplitBrainMergeTypes.CacheMergeTypes mergingEntry : this.mergingEntries) {
            out.writeObject(mergingEntry);
        }
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.mergingEntries = new ArrayList<SplitBrainMergeTypes.CacheMergeTypes>(size);
        for (int i = 0; i < size; ++i) {
            SplitBrainMergeTypes.CacheMergeTypes mergingEntry = (SplitBrainMergeTypes.CacheMergeTypes)in.readObject();
            this.mergingEntries.add(mergingEntry);
        }
        this.mergePolicy = (SplitBrainMergePolicy)in.readObject();
    }

    @Override
    public int getId() {
        return 65;
    }
}

