/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cache.impl.record;

import com.atlassian.nutcluster.cache.impl.record.CacheDataRecord;
import com.atlassian.nutcluster.cache.impl.record.CacheObjectRecord;
import com.atlassian.nutcluster.cache.impl.record.CacheRecord;
import com.atlassian.nutcluster.config.InMemoryFormat;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.serialization.SerializationService;

public class CacheRecordFactory<R extends CacheRecord> {
    protected InMemoryFormat inMemoryFormat;
    protected SerializationService serializationService;

    public CacheRecordFactory(InMemoryFormat inMemoryFormat, SerializationService serializationService) {
        this.inMemoryFormat = inMemoryFormat;
        this.serializationService = serializationService;
    }

    public R newRecordWithExpiry(Object value, long creationTime, long expiryTime) {
        return (R)(switch (this.inMemoryFormat) {
            case InMemoryFormat.BINARY -> {
                Object dataValue = this.serializationService.toData(value);
                yield this.createCacheDataRecord((Data)dataValue, creationTime, expiryTime);
            }
            case InMemoryFormat.OBJECT -> {
                Object objectValue = this.serializationService.toObject(value);
                yield this.createCacheObjectRecord(objectValue, creationTime, expiryTime);
            }
            case InMemoryFormat.NATIVE -> throw new IllegalArgumentException("Native storage format is supported in Nutcluster Enterprise only. Make sure you have Nutcluster Enterprise JARs on your classpath!");
            default -> throw new IllegalArgumentException("Invalid storage format: " + String.valueOf((Object)this.inMemoryFormat));
        });
    }

    protected CacheRecord createCacheDataRecord(Data dataValue, long creationTime, long expiryTime) {
        return new CacheDataRecord(dataValue, creationTime, expiryTime);
    }

    protected CacheRecord createCacheObjectRecord(Object objectValue, long creationTime, long expiryTime) {
        return new CacheObjectRecord(objectValue, creationTime, expiryTime);
    }

    public static boolean isExpiredAt(long expirationTime, long now) {
        return expirationTime > -1L && expirationTime <= now;
    }
}

