/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cardinality.impl;

import com.atlassian.nutcluster.cardinality.impl.CardinalityEstimatorContainer;
import com.atlassian.nutcluster.cardinality.impl.CardinalityEstimatorContainerCollector;
import com.atlassian.nutcluster.cardinality.impl.CardinalityEstimatorProxy;
import com.atlassian.nutcluster.cardinality.impl.hyperloglog.HyperLogLog;
import com.atlassian.nutcluster.cardinality.impl.operations.MergeOperation;
import com.atlassian.nutcluster.cardinality.impl.operations.ReplicationOperation;
import com.atlassian.nutcluster.config.CardinalityEstimatorConfig;
import com.atlassian.nutcluster.partition.strategy.StringPartitioningStrategy;
import com.atlassian.nutcluster.spi.ManagedService;
import com.atlassian.nutcluster.spi.MigrationAwareService;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.PartitionMigrationEvent;
import com.atlassian.nutcluster.spi.PartitionReplicationEvent;
import com.atlassian.nutcluster.spi.QuorumAwareService;
import com.atlassian.nutcluster.spi.RemoteService;
import com.atlassian.nutcluster.spi.SplitBrainHandlerService;
import com.atlassian.nutcluster.spi.impl.merge.AbstractContainerMerger;
import com.atlassian.nutcluster.spi.merge.SplitBrainMergePolicy;
import com.atlassian.nutcluster.spi.merge.SplitBrainMergeTypes;
import com.atlassian.nutcluster.spi.partition.IPartitionService;
import com.atlassian.nutcluster.spi.partition.MigrationEndpoint;
import com.atlassian.nutcluster.util.ConcurrencyUtil;
import com.atlassian.nutcluster.util.ConstructorFunction;
import com.atlassian.nutcluster.util.ContextMutexFactory;
import com.atlassian.nutcluster.util.MapUtil;
import com.atlassian.nutcluster.util.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CardinalityEstimatorService
implements ManagedService,
RemoteService,
MigrationAwareService,
QuorumAwareService,
SplitBrainHandlerService {
    public static final String SERVICE_NAME = "hz:impl:cardinalityEstimatorService";
    private static final double SIZING_FUDGE_FACTOR = 1.3;
    private static final Object NULL_OBJECT = new Object();
    private NodeEngine nodeEngine;
    private final ConcurrentMap<String, CardinalityEstimatorContainer> containers = new ConcurrentHashMap<String, CardinalityEstimatorContainer>();
    private final ConstructorFunction<String, CardinalityEstimatorContainer> cardinalityEstimatorContainerConstructorFunction = new ConstructorFunction<String, CardinalityEstimatorContainer>(){

        @Override
        public CardinalityEstimatorContainer createNew(String name) {
            CardinalityEstimatorConfig config = CardinalityEstimatorService.this.nodeEngine.getConfig().findCardinalityEstimatorConfig(name);
            return new CardinalityEstimatorContainer(config.getBackupCount(), config.getAsyncBackupCount());
        }
    };
    private final ConcurrentMap<String, Object> quorumConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory quorumConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> quorumConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            CardinalityEstimatorConfig config = CardinalityEstimatorService.this.nodeEngine.getConfig().findCardinalityEstimatorConfig(name);
            String quorumName = config.getQuorumName();
            return quorumName == null ? NULL_OBJECT : quorumName;
        }
    };

    public void addCardinalityEstimator(String name, CardinalityEstimatorContainer container) {
        Preconditions.checkNotNull(name, "Name can't be null");
        Preconditions.checkNotNull(container, "Container can't be null");
        this.containers.put(name, container);
    }

    public CardinalityEstimatorContainer getCardinalityEstimatorContainer(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.containers, name, this.cardinalityEstimatorContainerConstructorFunction);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void reset() {
        this.containers.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public CardinalityEstimatorProxy createDistributedObject(String objectName) {
        return new CardinalityEstimatorProxy(objectName, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String objectName) {
        this.containers.remove(objectName);
        this.quorumConfigCache.remove(objectName);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        int roughSize = (int)((double)this.containers.size() * 1.3 / (double)partitionService.getPartitionCount());
        Map<String, CardinalityEstimatorContainer> data = MapUtil.createHashMap(roughSize);
        int partitionId = event.getPartitionId();
        for (Map.Entry containerEntry : this.containers.entrySet()) {
            String name = (String)containerEntry.getKey();
            CardinalityEstimatorContainer container = (CardinalityEstimatorContainer)containerEntry.getValue();
            if (partitionId != this.getPartitionId(name) || event.getReplicaIndex() > container.getTotalBackupCount()) continue;
            data.put(name, (CardinalityEstimatorContainer)containerEntry.getValue());
        }
        return data.isEmpty() ? null : new ReplicationOperation(data);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearPartitionReplica(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearPartitionReplica(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearPartitionReplica(int partitionId, int durabilityThreshold) {
        Iterator iterator = this.containers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (this.getPartitionId((String)entry.getKey()) != partitionId || durabilityThreshold != -1 && durabilityThreshold <= ((CardinalityEstimatorContainer)entry.getValue()).getTotalBackupCount()) continue;
            iterator.remove();
        }
    }

    private int getPartitionId(String name) {
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        String partitionKey = StringPartitioningStrategy.getPartitionKey(name);
        return partitionService.getPartitionId(partitionKey);
    }

    @Override
    public String getQuorumName(String name) {
        Object quorumName = ConcurrencyUtil.getOrPutSynchronized(this.quorumConfigCache, name, this.quorumConfigCacheMutexFactory, this.quorumConfigConstructor);
        return quorumName == NULL_OBJECT ? null : (String)quorumName;
    }

    @Override
    public Runnable prepareMergeRunnable() {
        CardinalityEstimatorContainerCollector collector = new CardinalityEstimatorContainerCollector(this.nodeEngine, this.containers);
        collector.run();
        return new Merger(this, collector);
    }

    private class Merger
    extends AbstractContainerMerger<CardinalityEstimatorContainer, HyperLogLog, SplitBrainMergeTypes.CardinalityEstimatorMergeTypes> {
        Merger(CardinalityEstimatorService cardinalityEstimatorService, CardinalityEstimatorContainerCollector collector) {
            super(collector, cardinalityEstimatorService.nodeEngine);
        }

        @Override
        protected String getLabel() {
            return "cardinality estimator";
        }

        @Override
        public void runInternal() {
            CardinalityEstimatorContainerCollector collector = (CardinalityEstimatorContainerCollector)this.collector;
            ConcurrentMap containerMap = collector.getCollectedContainers();
            for (Map.Entry entry : containerMap.entrySet()) {
                int partitionId = (Integer)entry.getKey();
                Collection containerList = (Collection)entry.getValue();
                for (CardinalityEstimatorContainer container : containerList) {
                    String containerName = collector.getContainerName(container);
                    SplitBrainMergePolicy<HyperLogLog, SplitBrainMergeTypes.CardinalityEstimatorMergeTypes> mergePolicy = this.getMergePolicy(collector.getMergePolicyConfig(container));
                    MergeOperation operation = new MergeOperation(containerName, mergePolicy, container.hll);
                    this.invoke(CardinalityEstimatorService.SERVICE_NAME, operation, partitionId);
                }
            }
        }
    }
}

